@extends('layouts.app')
@section('content')
    <div class="min-h-svh bg-gray-50">
        @include('components.header')
        <main class="px-0 md:px-1 py-4 md:flex md:justify-center md:items-start md:pt-8">
            <div class="bg-white rounded-none md:rounded-lg shadow-none md:shadow-sm border-0 md:border border-gray-200 p-4 sm:p-6 mx-0 md:mx-1 md:max-w-4xl w-full" id="form">
                <div class="text-center mb-6 sm:mb-8">
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold text-gray-800 mb-2">Dados para Recebimento</h1>
                    <p class="text-gray-600 mb-4 text-sm sm:text-base"><span class="name-user"></span>, informe sua chave PIX para receber o valor</p>
                    <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 rounded-xl shadow-lg p-4 sm:p-6 text-white mb-6">
                        <p class="text-xs sm:text-sm text-blue-100 mb-1">Valor disponível para saque</p>
                        <p class="text-3xl sm:text-4xl md:text-5xl font-bold whitespace-nowrap">R$ 5.960,50</p>
                        <p class="text-xs sm:text-sm text-blue-100 mt-2">Transferência via PIX em até 10 minutos</p>
                    </div>
                </div>
                <form class="space-y-6" id="formChave" autocomplete="off">
                    <div>
                        <label class="block text-sm sm:text-base font-medium text-gray-700 mb-4">Selecione o tipo da sua chave PIX:</label>
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                            <label class="flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all border-blue-600 bg-blue-50 shadow-md">
                                <input class="sr-only" type="radio" value="cpf" name="tipoChave" checked>
                                <span class="text-2xl mr-3 flex-shrink-0">👤</span>
                                <span class="font-medium text-gray-700 text-sm sm:text-base">CPF</span>
                            </label>
                            <label class="flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all border-gray-200 hover:border-blue-300 hover:bg-gray-50">
                                <input class="sr-only" type="radio" value="email" name="tipoChave">
                                <span class="text-2xl mr-3 flex-shrink-0">📧</span>
                                <span class="font-medium text-gray-700 text-sm sm:text-base">E-mail</span>
                            </label>
                            <label class="flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all border-gray-200 hover:border-blue-300 hover:bg-gray-50">
                                <input class="sr-only" type="radio" value="telefone" name="tipoChave">
                                <span class="text-2xl mr-3 flex-shrink-0">📱</span>
                                <span class="font-medium text-gray-700 text-sm sm:text-base">Telefone</span>
                            </label>
                            <label class="flex items-center p-4 border-2 rounded-xl cursor-pointer transition-all border-gray-200 hover:border-blue-300 hover:bg-gray-50">
                                <input class="sr-only" type="radio" value="aleatoria" name="tipoChave">
                                <span class="text-2xl mr-3 flex-shrink-0">🔑</span>
                                <span class="font-medium text-gray-700 text-sm sm:text-base">Chave Aleatória</span>
                            </label>
                        </div>
                    </div>
                    <div id="chaveView">
                        <div>
                            <input type="hidden" name="tipo" id="tipo" value="CPF">
                            <label for="chavePix" class="block text-sm sm:text-base font-medium text-gray-700 mb-2">Digite sua chave PIX (CPF):</label>
                            <input id="chavePix" placeholder="000.000.000-00" inputmode="numeric" autocomplete="off" class="cpf-user w-full px-4 py-3 border-2 rounded-xl text-gray-700 placeholder-gray-400 focus:outline-none focus:ring-2 focus:border-blue-500 disabled:bg-gray-100 disabled:cursor-not-allowed transition-colors text-sm sm:text-base border-gray-300 focus:ring-blue-500" required="" type="text" value="" name="chavePix">
                        </div>
                    </div>
                    <div class="pt-4">
                        <button type="submit" class="w-full font-bold text-sm sm:text-base md:text-lg transition-all duration-300 transform flex items-center justify-center gap-2 sm:gap-3 shadow-lg py-4 sm:py-5 px-4 sm:px-6 rounded-xl sm:rounded-full touch-manipulation bg-green-600 hover:bg-green-700 active:bg-green-800 text-white hover:scale-105 cursor-pointer">
                            <svg class="w-5 h-5 sm:w-6 sm:h-6 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path></svg>
                            <span class="hidden sm:inline">Confirmar Chave PIX</span>
                            <span class="sm:hidden">Confirmar PIX</span>
                            <svg class="w-4 h-4 sm:w-5 sm:h-5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 010-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                        </button>
                    </div>
                </form>
                <div class="mt-6 sm:mt-8 p-3 sm:p-4 bg-gradient-to-r from-emerald-50 to-teal-50 border border-emerald-200 rounded-lg">
                    <div class="flex items-center gap-2 mb-2">
                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-emerald-600 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                        <h3 class="font-semibold text-emerald-800 text-sm sm:text-base">Importante</h3>
                    </div>
                    <p class="text-emerald-700 text-xs sm:text-sm">Verifique cuidadosamente sua chave PIX antes de confirmar. O valor será transferido diretamente para a conta vinculada a esta chave.</p>
                </div>
            </div>
            <div class="bg-white rounded-none md:rounded-lg shadow-none md:shadow-sm border-0 md:border border-gray-200 p-4 sm:p-6 mx-0 md:mx-1 md:max-w-4xl w-full hidden" id="confirma">
                <div class="space-y-6">
                    <div class="text-center">
                        <h2 class="text-xl sm:text-2xl font-bold text-gray-800 mb-2">Confirme sua Chave PIX</h2>
                        <p class="text-gray-600 text-sm sm:text-base">Verifique se os dados estão corretos antes de prosseguir</p>
                    </div>
                    <div class="bg-white rounded-xl shadow-md border-2 border-blue-100 overflow-hidden">
                        <div class="bg-gradient-to-r from-blue-600 to-blue-700 px-4 sm:px-6 py-3">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-white/20 rounded-lg flex items-center justify-center flex-shrink-0">
                                    <span class="text-2xl">👤</span>
                                </div>
                                <div class="flex-1 min-w-0">
                                    <h3 class="text-base sm:text-lg font-bold text-white">Chave PIX - CPF</h3>
                                    <p class="text-blue-100 text-xs sm:text-sm">Confirme os dados abaixo</p>
                                </div>
                            </div>
                        </div>
                        <div class="p-4 sm:p-6">
                            <p class="text-gray-600 text-xs sm:text-sm mb-2">Sua chave PIX:</p>
                            <p class="text-blue-600 font-mono text-base sm:text-lg md:text-xl font-bold break-all" id="chaveEscolhida"></p>
                        </div>
                    </div>
                    <div class="processamento"></div>
                    <div class="space-y-3" id="acoes">
                        <button class="w-full bg-green-600 hover:bg-green-700 text-white py-4 sm:py-5 px-4 sm:px-6 rounded-xl sm:rounded-full font-bold text-sm sm:text-base md:text-lg transition-all duration-300 flex items-center justify-center gap-2 sm:gap-3 shadow-lg hover:scale-105" id="confirmaChave">
                            <svg class="w-5 h-5 sm:w-6 sm:h-6 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path></svg>
                            <span class="hidden sm:inline">Confirmar Chave PIX</span>
                            <span class="sm:hidden">Confirmar</span>
                        </button>
                        <button class="w-full bg-gray-500 hover:bg-gray-600 text-white py-3 sm:py-4 px-4 sm:px-6 rounded-xl sm:rounded-full font-medium text-sm sm:text-base transition-colors" id="editChave">Editar Chave</button>
                    </div>
                </div>
            </div>
        </main>
    </div>
<style>
@keyframes spin {
  to {
    transform: rotate(360deg);
  }
}
.animate-spin {
  animation: spin 1s linear infinite;
}
</style>
@endsection
@section('javascript')
    <script>
        function mascarar(){
            $('.cpf-user').mask('000.000.000-00');
            $('.telefone-user').mask('(00) 00000-0000');
        }

        mascarar();

        $('input[name="tipoChave"]').on('change', function() {
            $('label').removeClass('border-blue-600 bg-blue-50 shadow-md').addClass('border-gray-200 hover:border-blue-300 hover:bg-gray-50');
            $(this).closest('label').addClass('border-blue-600 bg-blue-50 shadow-md').removeClass('border-gray-200 hover:border-blue-300 hover:bg-gray-50');

            const tipoChave = $(this).val();

            if(tipoChave == 'cpf'){
                $('#chaveView').html(`
                    <div>
                        <input type="hidden" name="tipo" id="tipo" value="CPF">
                        <label for="chavePix" class="block text-sm sm:text-base font-medium text-gray-700 mb-2">Digite sua chave PIX (CPF):</label>
                        <input id="chavePix" placeholder="000.000.000-00" inputmode="numeric" autocomplete="off" class="cpf-user w-full px-4 py-3 border-2 rounded-xl text-gray-700 placeholder-gray-400 focus:outline-none focus:ring-2 focus:border-blue-500 disabled:bg-gray-100 disabled:cursor-not-allowed transition-colors text-sm sm:text-base border-gray-300 focus:ring-blue-500" required="" type="text" value="" name="chavePix">
                    </div>
                `);
                mascarar();
            }
            if(tipoChave == 'email'){
                $('#chaveView').html(`
                    <div>
                        <input type="hidden" name="tipo" id="tipo" value="E-mail">
                        <label for="chavePix" class="block text-sm sm:text-base font-medium text-gray-700 mb-2">Digite sua chave PIX (E-mail):</label>
                        <input id="chavePix" placeholder="seuemail@exemplo.com" inputmode="text" autocomplete="email" class="w-full px-4 py-3 border-2 rounded-xl text-gray-700 placeholder-gray-400 focus:outline-none focus:ring-2 focus:border-blue-500 disabled:bg-gray-100 disabled:cursor-not-allowed transition-colors text-sm sm:text-base border-gray-300 focus:ring-blue-500" required="" type="email" value="" name="chavePix">
                    </div>
                `);
                mascarar();
            }
            if(tipoChave == 'telefone'){
                $('#chaveView').html(`
                    <div>
                        <input type="hidden" name="tipo" id="tipo" value="Telefone">
                        <label for="chavePix" class="block text-sm sm:text-base font-medium text-gray-700 mb-2">Digite sua chave PIX (Telefone com DDD):</label>
                        <input id="chavePix" placeholder="(11) 99999-9999" inputmode="numeric" autocomplete="tel" class="telefone-user w-full px-4 py-3 border-2 rounded-xl text-gray-700 placeholder-gray-400 focus:outline-none focus:ring-2 focus:border-blue-500 disabled:bg-gray-100 disabled:cursor-not-allowed transition-colors text-sm sm:text-base border-gray-300 focus:ring-blue-500" required="" type="text" value="" name="chavePix">
                    </div>
                `);
                mascarar();
            }
            if(tipoChave == 'aleatoria'){
                $('#chaveView').html(`
                    <div>
                        <input type="hidden" name="tipo" id="tipo" value="Aleatória">
                        <label for="chavePix" class="block text-sm sm:text-base font-medium text-gray-700 mb-2">Digite sua chave PIX (Chave Aleatória):</label>
                        <input id="chavePix" placeholder="Cole sua chave PIX aleatória aqui" inputmode="text" autocomplete="off" class="w-full px-4 py-3 border-2 rounded-xl text-gray-700 placeholder-gray-400 focus:outline-none focus:ring-2 focus:border-blue-500 disabled:bg-gray-100 disabled:cursor-not-allowed transition-colors text-sm sm:text-base border-gray-300 focus:ring-blue-500" required="" type="text" value="" name="chavePix">
                    </div>
                `);
                mascarar();
            }
        });

        $(document).on('submit', '#formChave', function(e){
            e.preventDefault();

            const pixValue = $('#chavePix').val();
            const tipo = $('#tipo').val();

            if(pixValue == ''){
                return;
            }

            localStorage.setItem('chavePix', pixValue);
            localStorage.setItem('tipoPIX', tipo);

            $('#form').addClass('hidden');
            $('#confirma').removeClass('hidden');

            let chavePix = localStorage.getItem('chavePix') || '';

            $('#chaveEscolhida').text(chavePix);

            $(document).on('click', '#editChave', function(){
                $('#confirma').addClass('hidden');
                $('#form').removeClass('hidden');
            });

            $(document).on('click', '#confirmaChave', function(){
                $('#acoes').remove();
                $('.processamento').html(`
                    <div class="bg-yellow-50 border border-yellow-200 rounded-xl p-4 sm:p-6 text-center">
                        <div class="w-12 h-12 border-4 border-yellow-600 border-t-transparent rounded-full animate-spin mx-auto mb-4"></div>
                        <h3 class="font-semibold text-yellow-800 mb-2 text-sm sm:text-base">Vinculando Chave PIX</h3>
                        <p class="text-yellow-700 text-xs sm:text-sm">Aguarde enquanto processamos sua chave PIX...</p>
                    </div>
                `);

                setInterval(() => {
                    $('.processamento').html(`
                        <div class="bg-green-50 border border-green-200 rounded-xl p-4 sm:p-6 text-center">
                            <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                <svg class="w-8 h-8 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <h3 class="font-semibold text-green-800 mb-2 text-sm sm:text-base">Chave PIX Vinculada com Sucesso!</h3>
                            <p class="text-green-700 text-xs sm:text-sm">Redirecionando para a próxima etapa...</p>
                        </div>
                    `);
                    setInterval(() => {
                        window.location.href = "{{ url('/comprovante') }}";
                    }, 1500);
                }, 1500);
            });
        });

    </script>
@endsection