@extends('layouts.app')
@section('content')
    <div class="min-h-svh bg-gray-50">
        @include('components.header')
        <main class="px-0 md:px-1 py-4 md:flex md:justify-center md:items-start md:pt-8">
            <div class="bg-white rounded-none md:rounded-lg shadow-none md:shadow-sm border-0 md:border border-gray-200 p-3 mx-0 md:mx-1 md:max-w-4xl w-full py-5 px-3">
                <div class="text-center mb-8">
                    <h1 class="text-2xl font-bold text-gray-800 mb-2">Confirmação do Processo</h1>
                    <p class="text-gray-600 mb-4">Revise as informações antes de finalizar o saque</p>
                </div>
                <div class="mb-8">
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 px-1.5 py-1.5">
                        <div class="flex items-center justify-center flex-row mb-1.5">
                            <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                                <span class="text-xl">🔊</span>
                            </div>
                        </div>
                        <div class="p-0 border absolute opacity-0 hidden" id="audio-player-wrapper">
                            <audio id="audio-player" src="{{ url('public/audios/faltapouco.mp3') }}" autoplay class="w-full"></audio>
                        </div>
                        <div class="bg-white rounded-lg p-3 border border-blue-200 px-1.5 py-1.5 leading-7" id="btn-wrapper">
                            <div class="w-full">
                                <div class="text-center">
                                    <button id="play-audio-btn" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg font-medium transition-colors">🔊 Escutar instruções</button>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white rounded-lg p-3 border border-blue-200 px-1.5 py-1.5 leading-7 hidden" id="playing-wrapper">
                            <div class="w-full">
                                <div class="bg-blue-50 border border-blue-200 rounded-lg p-3 text-center">
                                    <div class="flex items-center justify-center gap-2">
                                        <div class="flex gap-1">
                                            <div class="w-1 h-4 bg-blue-600 rounded audio-pulse-bar"></div>
                                            <div class="w-1 h-4 bg-blue-600 rounded audio-pulse-bar"></div>
                                            <div class="w-1 h-4 bg-blue-600 rounded audio-pulse-bar"></div>
                                        </div>
                                        <span class="text-sm font-medium text-blue-700">🔊 Reproduzindo instruções...</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white rounded-lg p-3 border border-blue-200 px-1.5 py-1.5 leading-7 hidden" id="done-wrapper">
                            <div class="w-full">
                                <div class="bg-green-50 border border-green-200 rounded-lg p-3 text-center">
                                    <span class="text-sm font-medium text-green-700">✅ Instruções concluídas</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mb-8">
                    <div class="bg-gray-50 border border-gray-200 rounded-lg p-4 py-2 px-2">
                        <div class="flex items-center gap-3 mb-4">
                            <svg class="w-6 h-6 text-gray-600" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4 4a2 2 0 012-2h4.586A2 2 0 0112 2.586L15.414 6A2 2 0 0116 7.414V16a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm2 6a1 1 0 011-1h6a1 1 0 110 2H7a1 1 0 01-1-1zm1 3a1 1 0 100 2h6a1 1 0 100-2H7z" clip-rule="evenodd"></path>
                            </svg>
                            <h3 class="text-lg font-semibold text-gray-800">Seu Comprovante</h3>
                        </div>
                        <div class="progressoComprovante"></div>
                    </div>
                </div>
                <button id="timer-btn" disabled="" class="w-full py-4 px-6 rounded-full font-bold text-lg transition-all duration-300 flex items-center justify-center gap-2 bg-gray-400 text-white cursor-not-allowed opacity-75">
                    <div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>
                    Aguarde 8s
                </button>
                <div class="mt-8 mb-8">
                    <div class="bg-green-50 border border-green-200 rounded-lg p-4 text-center">
                        <p class="text-sm text-green-700 mb-1">Valor para saque:</p>
                        <p class="text-3xl font-bold text-green-600">R$ 5960,50</p>
                        <p class="text-sm text-green-600 mt-1">CPF: <span class="cpf-user"></span></p>
                    </div>
                </div>
                <div class="p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
                    <div class="flex items-center gap-2 mb-2">
                        <svg class="w-5 h-5 text-yellow-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path></svg>
                        <h3 class="font-semibold text-yellow-800">Atenção</h3>
                    </div>
                    <p class="text-yellow-700 text-sm">Certifique-se de ter ouvido as instruções no áudio e verificado o comprovante antes de finalizar o processo. Após clicar em "FINALIZAR SAQUE", o processo será concluído.</p>
                </div>
            </div>
        </main>
    </div>
<style>
@keyframes spin {
  to {
    transform: rotate(360deg);
  }
}
.animate-spin {
  animation: spin 2s linear infinite;
}
@keyframes fade-in {
  from {
    opacity: 0;
    transform: translateY(20px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}
.animate-fade-in {
  animation: fade-in 0.8s ease-out forwards;
}
</style>
@endsection
@section('javascript')
<script>
    const btnWrapper = document.getElementById('btn-wrapper');
    const playBtn = document.getElementById('play-audio-btn');
    const audioWrapper = document.getElementById('audio-player-wrapper');
    const audioEl = document.getElementById('audio-player');
    const playingWrapper = document.getElementById('playing-wrapper');
    const doneWrapper = document.getElementById('done-wrapper');

    function startAudio() {
        btnWrapper.classList.add('hidden');
        playingWrapper.classList.remove('hidden');
        audioWrapper.classList.remove('hidden');

        audioEl.play().catch((e) => {
            console.log('Autoplay bloqueado:', e);
            btnWrapper.classList.remove('hidden');
            playingWrapper.classList.add('hidden');
            audioWrapper.classList.add('hidden');
        });
    }

    playBtn.addEventListener('click', startAudio);

    audioEl.addEventListener('ended', () => {
        playingWrapper.classList.add('hidden');
        audioWrapper.classList.add('hidden');
        doneWrapper.classList.remove('hidden');
    });

    window.addEventListener('load', () => {
        startAudio();
    });

    const nameValue = localStorage.getItem("name") || "";

    $('.progressoComprovante').html(`
        <div class="bg-white rounded-lg p-6 text-center border border-gray-200 animate-fade-in">
            <div class="w-16 h-16 border-4 border-blue-600 border-t-transparent rounded-full animate-spin mx-auto mb-4"></div>
            <h4 class="text-lg font-semibold text-gray-800 mb-2">Gerando seu comprovante...</h4>
            <p class="text-gray-600 text-sm mb-4">Aguarde enquanto validamos suas informações e geramos o documento oficial.</p>
            <div class="mt-4 bg-blue-50 border border-blue-200 rounded-lg p-3">
                <p class="text-blue-700 text-xs">⏳ Este processo pode levar alguns segundos para garantir a autenticidade do documento.</p>
            </div>
        </div>
    `);

    setTimeout(() => {
        $('.progressoComprovante').html(`
            <div class="bg-white border border-green-200 rounded-xl p-4 sm:p-6 text-center animate-fade-in">
                <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <h3 class="font-semibold text-green-800 mb-2 text-sm sm:text-base">✅ Comprovante Gerado com Sucesso!</h3>
                <p class="text-green-700 text-sm mb-4">Seu comprovante oficial foi gerado e validado com sucesso. Carregando visualização</p>
                <div class="bg-green-50 border border-green-200 rounded-lg p-3">
                    <p class="text-green-700 text-xs font-medium">🔒 Documento autenticado e pronto para visualização</p>
                </div>
            </div>
        `);

        setTimeout(() => {
            $('.progressoComprovante').html(`
                <div class="text-center animate-fade-in">
                    <div class="flex justify-center px-3 py-3">
                        <img src="https://consultaragorafacil.com/comprovante/?nome=${nameValue}?v=${Date.now()}" alt="Comprovante" id="comprovanteImg" class="max-w-[370px]">
                    </div>
                    <p class="text-center text-xs text-gray-500 mt-2">💡 Clique na imagem para visualizar em tela cheia</p>
                </div>
            `);
        }, 3000);
    }, 3000);

    const btn = document.getElementById('timer-btn');
    let timeLeft = 8;

    const interval = setInterval(() => {
        timeLeft--;
        btn.innerHTML = `<div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div> Aguarde ${timeLeft}s`;

        if (timeLeft <= 0) {
            clearInterval(interval);
            btn.disabled = false;
            btn.className = "w-full py-4 px-6 rounded-full font-bold text-lg transition-all duration-300 flex items-center justify-center gap-2 bg-green-600 hover:bg-green-700 text-white transform hover:scale-102 cursor-pointer";
            btn.innerHTML = `<svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"></path></svg> FINALIZAR SAQUE`;
        }
    }, 1000);

    $(document).on('click', '#timer-btn', function(){
        window.location.href = "{{ url('/video-tarifa') }}";
    });
</script>
@endsection