@extends('layouts.app')
<style>
img {
vertical-align: middle;
display: inline-block;
height: auto;
max-width: 100%;
border: none;
border-radius: 0;
box-shadow: none;
}
.progress-container {
width: calc(100% - 30px);
max-width: calc(100% - 20px);
height: 140px;
padding: 0 10px;
display: flex;
align-items: center;
justify-content: center;
gap: 8px;
margin-bottom: 30px;
}
.progress-container > div {
max-width: 24%;
position: relative;
}
p#text1, p#text2, p#text3, p#text4 {
margin: 0;
margin-top: 5px;
max-width: 80px;
min-height: 36px;
text-align: center;
font-size: 12px;
line-height: 16px;
position: absolute;
}
p#text1 {
left: 33px;
}
p#text2 {
left: 29px;
}
p#text3 {
left: 32px;
}
p#text4 {
left: 37px;
}
.progress-item {
display: flex;
justify-content: space-between;
align-items: center;
gap: 8px;
}
.progress-bar {
width: 40px;
height: 4px;
border-radius: 4px;
background: linear-gradient(to right, #B6B6B6 0%, #B6B6B6 100%);
}
.progress-bar2 {
width: 0;
height: 4px;
border-radius: 4px;
background-color: #4CAF50;
transition: width 0.8s ease-out;
}
.check-container {
width: 40px;
}
.check-container > img {
width: 40px;
height: auto;
}
section#more-information {
display: flex;
flex-direction: column;
align-items: center;
justify-content: center;
padding: 0 10px;
opacity: 0;
transition: opacity 2s ease-out;
}
section > h1 {
font-size: 25px;
color: #2263ae;
font-weight: 800;
margin-bottom: 15px;
}
section > h2 {
font-size: 18px;
color: #000000;
font-weight: 600;
margin-bottom: 30px;
}
section > p {
text-align: center;
margin-bottom: 25px;
line-height: 20px;
}
span.bold {
font-weight: bold;
}
span.bold2 {
font-weight: bold;
color: #254DDB;
}
span.bold3 {
font-weight: bold;
color: #00B309;
}
span.bold4 {
font-weight: bold;
color: #FF0000;
}
section > button {
font-size: 22px;
font-weight: 600;
border-radius: 10px 10px 10px 10px;
padding: 15px 30px 15px 30px;
background-color: #2865AE;
color: rgb(255, 255, 255);
border: none;
margin-top: 15px;
}
.modal {
display: none;
position: fixed;
z-index: 1;
left: 0;
top: 0;
width: 100%;
height: 100%;
overflow: auto;
background-color: rgba(0,0,0,0.4);
justify-content: center;
align-items: center;
}
.modal-content {
background-color: #FEFEFE;
padding: 20px;
border: 1px solid #888888;
width: 80%;
max-width: 500px;
box-shadow: 0 4px 8px rgba(0,0,0,0.2);
border-radius: 8px;
}
.modal-content > div#step1 {
display: flex;
flex-direction: column;
justify-content: center;
transition: opacity 0.3s ease-out;
}
.modal-content > div#step1 > h1 {
font-size: 25px;
line-height: 29px;
text-align: left;
color: #000000;
font-weight: 700;
text-align: center;
}
.modal-content > div#step1 > p {
text-align: center;
font-size: 18px;
line-height: 20px;
font-weight: 500;
}
div#trace {
margin: 20px 0;
}
.modal-content > div#step2 {
display: none;
flex-direction: column;
align-items: center;
}
.modal-content > div#step2 > p {
font-size: 18px;
line-height: 20px;
text-align: center;
}
.modal-content > div#step2 > span#value {
color: #FF0000;
font-size: 23px;
font-weight: bold;
line-height: 20px;
text-align: center;
display: block;
margin: 20px 0;
}
.modal-content > div#step2 > h1 {
font-size: 22px;
line-height: 20px;
text-align: center;
color: #00B309;
font-weight: bold;
text-decoration: underline;
margin-top: 24px;
margin-bottom: 15px;
}
.modal-content > div#step2 > h1#value {
font-size: 30px;
text-decoration: none;
}
.modal-content > div#step2 > a {
font-size: 20px;
font-weight: 600;
border-radius: 10px 10px 10px 10px;
padding: 15px 25px 15px 25px;
background-color: #2D6EFF;
color: white;
text-decoration: none;
margin-top: 30px;
margin-bottom: 15px;
cursor:pointer;
}
.modal-content > div#step2 > p:last-child {
font-size: 15px;
}
</style>
@section('content')
    <div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50">
        @include('components.header')
        <main class="pt-5 pb-8 px-4">
            <div class="max-w-xl mx-auto">
                <div class="progress-container">
                    <div>
                        <div class="progress-item">
                            <div class="progress-bar" id="bar1"></div>
                            <div class="check-container" id="check1">
                                <img src="{{ url('public/images/qlKo5ZF7Eju4.png') }}" alt="Animação" id="img1">
                            </div>
                        </div>
                        <p id="text1">Analisando Dados</p>
                    </div>
                    <div>
                        <div class="progress-item">
                            <div class="progress-bar" id="bar2"></div>
                            <div class="check-container" id="check2">
                                <img src="{{ url('public/images/qlKo5ZF7Eju4.png') }}" alt="Animação" id="img2">
                            </div>
                        </div>
                        <p id="text2">Preparando transferência</p>
                    </div>
                    <div>
                        <div class="progress-item">
                            <div class="progress-bar" id="bar3"></div>
                            <div class="check-container" id="check3">
                                <img src="{{ url('public/images/qlKo5ZF7Eju4.png') }}" alt="Animação" id="img3">
                            </div>
                        </div>
                        <p id="text3">Pagamento Efetuado</p>
                    </div>
                    <div>
                        <div class="progress-item">
                            <div class="progress-bar" id="bar4"></div>
                            <div class="check-container" id="check4">
                                <img src="{{ url('public/images/qlKo5ZF7Eju4.png') }}" alt="Animação" id="img4">
                            </div>
                        </div>
                        <p id="text4">Concluido</p>
                    </div>
                </div>
                <section id="more-information">
                    <h1>PARABÉNS</h1>
                    <h2>Protocolo: 6481749338</h2>
                    <p>Seu processo foi concluído com sucesso e sua indenização está a caminho.</p>
                    <p>Agradecemos por ter percorrido todas as etapas e garantido seu direito de forma segura e eficiente. Agora, basta aguardar o prazo estabelecido para o crédito do valor na sua conta, conforme informado durante o processo.</p>
                    <p>Reforçamos nosso compromisso em garantir que todos os cidadãos elegíveis recebam seus benefícios de maneira transparente e sem burocracia.</p>
                    <p>Caso precise de suporte ou tenha alguma dúvida, nossa equipe está à disposição para auxiliá-lo(a).</p>
                </section>
            </div>
        </main>
    </div>
@endsection
@section('javascript')
<script>
    function animateBar(barId, imgId) {
        const traco = document.getElementById(barId);
        let startTime = null;

        window.requestAnimationFrame(function step(timestamp) {
            if (!startTime) startTime = timestamp;
            const progress = timestamp - startTime;
            const percentage = Math.min(progress / 900, 1);

            traco.style.background = `linear-gradient(to right, #4CAF50 ${100 * percentage}%, #E5E7EB ${100 * percentage}%)`;

            if (progress < 900) {
                window.requestAnimationFrame(step);
            } else {
                traco.style.background = "#4CAF50";
                document.getElementById(imgId).src = "{{ url('public/images/success.gif') }}?" + imgId;
            }
        });
    }

    function showProgressAndCheck(barId, checkId, imgId, textId, delay) {
        setTimeout(() => {
            animateBar(barId, imgId);
            if (checkId === "check3") {
                setTimeout(() => {
                    const moreInfo = document.getElementById("more-information");
                    if (moreInfo) moreInfo.style.opacity = 1;
                    const showOffer = document.getElementById("show-offer");
                    if (showOffer) showOffer.disabled = false;
                }, 900 + 1000);
            }
        }, delay);
    }

    document.addEventListener("DOMContentLoaded", function() {
        showProgressAndCheck("bar1", "check1", "img1", "text1", 0);
        showProgressAndCheck("bar2", "check2", "img2", "text2", 1000);
        showProgressAndCheck("bar3", "check3", "img3", "text3", 2000);
        showProgressAndCheck("bar4", "check4", "img4", "text4", 3000);

        const modal = document.getElementById("offer-modal");
        const showOfferBtn = document.getElementById("show-offer");

        if (showOfferBtn) {
            showOfferBtn.addEventListener("click", () => {
                modal.style.display = "flex";
                setTimeout(() => {
                    const trace = document.getElementById("trace");
                    if (trace) {
                        trace.style.width = "100%";
                        setTimeout(() => {
                            const step1 = document.getElementById("step1");
                            const step2 = document.getElementById("step2");
                            if (step1) step1.style.opacity = 0;
                            setTimeout(() => {
                                if (step1) step1.style.display = "none";
                                if (step2) step2.style.display = "flex";
                            }, 400);
                        }, 2000);
                    }
                }, 800);
            });
        }

        // Fecha modal ao clicar fora
        window.addEventListener("click", event => {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        });
    });
</script>
@endsection