@extends('layouts.app')
@section('content')
    <div class="bg-gray-50" style="min-height:calc(100vh - 57px)">
        @include('components.header')
        <main class="px-0 md:px-1 py-4 md:flex md:justify-center md:items-start md:pt-8">
            <div class="bg-white rounded-xl shadow-md border border-gray-200 p-4 sm:p-6 max-w-3xl mx-auto">
                <div>
                    <div class="text-center">
                        <h1 class="text-lg font-semibold text-gray-800 leading-tight">Falta pouco! Para receber seus valores, efetue o pagamento com PIX!</h1>
                    </div>
                    <div class="text-center mt-3 mb-3">
                        <p class="text-gray-600 text-sm">O código expira em: <span id="timer" class="text-red-500 font-semibold">15:00</span></p>
                    </div>
                    <div class="text-center">
                        <p class="text-gray-700 text-sm mb-4">Escaneie o QR Code com seu aplicativo de pagamento:</p>
                        <div class="flex justify-center mb-4">
                            <div class="bg-white p-3 rounded-lg border border-gray-300 shadow-sm">
                                <img src="{{ $pedido->qrcode }}" alt="QR Code PIX" class="w-40 h-40 mx-auto">
                            </div>
                        </div>
                        <p class="text-sm text-gray-600 mb-4">ou</p>
                    </div>
                    <div class="text-center">
                        <p class="text-gray-700 text-sm">Copie a chave abaixo e utilize a<br>opção <strong>PIX Copia e Cola:</strong></p>
                    </div>
                    <div class="space-y-3">
                        <label class="block text-sm font-medium text-gray-700">Código PIX (Copia e Cola)</label>
                        <div class="bg-gray-50 border border-gray-300 rounded-lg p-3 cursor-pointer hover:bg-gray-100 transition-colors">
                            <div id="codigo" class="text-xs text-gray-700 truncate">{{ $pedido->copiacola }}</div>
                        </div>
                        <button id="copiar-btn" data-slot="button" class="uppercase whitespace-nowrap text-sm transition-all disabled:pointer-events-none disabled:opacity-50 [&amp;_svg]:pointer-events-none [&amp;_svg:not([class*='size-'])]:size-4 shrink-0 [&amp;_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive shadow-xs h-11 px-4 has-[&gt;svg]:px-3 w-full bg-green-600 hover:bg-green-700 text-white font-medium py-3 rounded-lg flex items-center justify-center gap-2">
                            <svg width="16" height="16" fill="currentColor" viewBox="0 0 24 24"><path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"></path></svg>
                            Copiar Código
                        </button>
                    </div>
                    <div class="text-center mt-4 mb-4">
                        <p class="text-gray-600 text-sm">Valor a ser pago: <span class="text-green-600 font-semibold">R$ {{ number_format($pedido->valor,2,',','.') }}</span></p>
                    </div>
                    <div class="border border-gray-200 rounded-lg">
                        <div class="px-4 py-3">
                            <span class="font-medium text-gray-800">Instruções para pagamento</span>
                        </div>
                        <div class="px-4 pb-4 space-y-4">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-green-600 rounded-full flex items-center justify-center flex-shrink-0">
                                    <svg width="16" height="16" fill="white" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm3.5 6L12 10.5 8.5 8 12 5.5 15.5 8zM12 13.5L8.5 16 12 18.5 15.5 16 12 13.5z"></path></svg>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-700">Após copiar o código, abra seu aplicativo de pagamento onde você utiliza o Pix.</p>
                                </div>
                            </div>
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-green-600 rounded-full flex items-center justify-center flex-shrink-0">
                                    <svg width="16" height="16" fill="white" viewBox="0 0 24 24"><path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"></path></svg>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-700">Escolha a opção <strong>PIX Copia e Cola</strong> e insira o código copiado.</p>
                                </div>
                            </div>
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-green-600 rounded-full flex items-center justify-center flex-shrink-0">
                                    <svg width="16" height="16" fill="white" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm3.5 6L12 10.5 8.5 8 12 5.5 15.5 8zM12 13.5L8.5 16 12 18.5 15.5 16 12 13.5z"></path></svg>
                                </div>
                                <div>
                                    <p class="text-sm text-gray-700">Confirme as informações e efetue o pagamento.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <div class="px-6 py-4 border-t border-gray-200 bg-gray-50">
        <div class="flex items-center justify-center gap-4">
            <div class="flex items-center gap-2">
                <svg width="24" height="24" fill="#00AA5B" viewBox="0 0 24 24"><path d="M12,1L3,5V11C3,16.55 6.84,21.74 12,23C17.16,21.74 21,16.55 21,11V5L12,1M10,17L6,13L7.41,11.59L10,14.17L16.59,7.58L18,9L10,17Z"></path></svg>
                <span class="text-sm font-semibold text-green-600">PIX</span>
            </div>
            <div class="flex items-center gap-2">
                <svg width="16" height="16" fill="#666" viewBox="0 0 24 24"><path d="M12,1L3,5V11C3,16.55 6.84,21.74 12,23C17.16,21.74 21,16.55 21,11V5L12,1M10,17L6,13L7.41,11.59L10,14.17L16.59,7.58L18,9L10,17Z"></path></svg>
                <span class="text-xs text-gray-600">Ambiente seguro</span>
            </div>
        </div>
    </div>
@endsection
@section('javascript')
<script>
    let duration = 15 * 60;
    const timerEl = document.getElementById("timer");

    function updateTimer() {
        const minutes = Math.floor(duration / 60);
        const seconds = duration % 60;
        timerEl.textContent = `${minutes}:${seconds.toString().padStart(2, '0')}`;

        if (duration > 0) {
            duration--;
            setTimeout(updateTimer, 1000);
        } else {
            timerEl.textContent = "Expirado";
            timerEl.classList.remove('text-red-500');
            timerEl.classList.add('text-gray-500');
        }
    }

    updateTimer();

    document.getElementById('copiar-btn').addEventListener('click', function() {
        const codigo = document.getElementById('codigo').innerText.trim();
        const btn = this;

        navigator.clipboard.writeText(codigo).then(() => {
            btn.innerHTML = 'Código copiado com sucesso!';
            btn.classList.remove('bg-green-600', 'hover:bg-green-700');
            btn.classList.add('bg-green-500');

            setTimeout(() => {
                btn.innerHTML = `
                    <svg width="16" height="16" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14
                                c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"></path>
                    </svg>
                    Copiar Código
                `;
                btn.classList.remove('bg-green-500');
                btn.classList.add('bg-green-600', 'hover:bg-green-700');
            }, 4000);
        }).catch(() => {
            alert('Não foi possível copiar o código.');
        });
    });

    let paymentConfirmed = false;
    
    startPaymentStatusCheck("{{ $pedido->transacao }}");

    const service = "{{ $pedido->servico }}";
        
    function startPaymentStatusCheck(transactionId) {
        const startTime = Date.now();
        const maxDuration = 30 * 60 * 1000;
        
        async function loopCheck() {
            if (paymentConfirmed || Date.now() - startTime > maxDuration) {
                return;
            }
        
            await checkPaymentStatus(transactionId);
                
            if (!paymentConfirmed) {
                setTimeout(loopCheck, 3000);
            }
        }
        
        loopCheck();
    }
        
    async function checkPaymentStatus(transactionId) {
        try {
            const response = await fetch("{{ url('/confirmar') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ transactionId:transactionId })
            });
            const data = await response.json();
            if (data.success) {
                paymentConfirmed = true;

                if(service == 'Payment TR'){
                    window.location.href = "{{ url('/liberacao') }}";
                }

                if(service == 'Payment TR Upsell 01'){
                    window.location.href = "{{ url('/iof') }}";
                }

                if(service == 'Payment TR Upsell 02'){
                    window.location.href = "{{ url('/analise') }}";
                }

                if(service == 'Payment TR Upsell 03'){
                    window.location.href = "{{ url('/receita-federal') }}";
                }

                if(service == 'Payment TR Upsell 04'){
                    window.location.href = "{{ url('/concluido') }}";
                }
            }
        } catch (error) {
            console.error('Erro ao verificar status do pagamento:', error);
        }
    }

</script>
@endsection