@extends('layouts.app')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<link rel="stylesheet" href="{{ url('public/css/presell.css') }}">
@section('content')
    <div class="container" style="margin:auto;">
        <div class="content-box">
            <h1 class="title">Plataforma de Consulta de Informações</h1>
            <p class="subtitle">Acesse informações de forma rápida, segura e gratuita através da nossa plataforma.</p>
            <div class="trust-indicators">
                <div class="trust-item">
                    <i class="fas fa-shield-alt"></i>
                    <span>Seguro</span>
                </div>
                <div class="trust-item">
                    <i class="fas fa-check-circle"></i>
                    <span>Verificado</span>
                </div>
                <div class="trust-item">
                    <i class="fas fa-lock"></i>
                    <span>Gratuito</span>
                </div>
            </div>
            <button id="consultButton" class="cta-button">
                CONSULTAR AGORA
            </button>
            <p class="disclaimer">
                Seus dados são protegidos conforme a LGPD. Consulta 100% gratuita e segura.
            </p>
        </div>
    </div>
    <footer>
        <div class="footer-content">
            <div class="footer-company" style="text-align:center;">
                <div class="company-name">SUPER TRUCK COMÉRCIO E SERVIÇOS LTDA</div>
                <div class="company-info">
                    CNPJ: 47.319.222/0001-74<br>
                    ROD BR 101, 24000 - Araquari/SC - CEP 89245-000<br>
                    Telefones: (11) 4137-0440 / (11) 4787-3331<br>
                    Email: <a href="mailto:thiagonascimentobispodossantos@gmail.com">thiagonascimentobispodossantos@gmail.com</a>
                </div>
            </div>
            
            <div class="footer-links">
                <a href="politica-privacidade.html">Política de Privacidade</a>
                <a href="termos-uso.html">Termos de Uso</a>
                <a href="contato.html">Contato</a>
            </div>
            
            <div class="footer-copyright">
                &copy; 2025 SUPER TRUCK COMÉRCIO E SERVIÇOS LTDA. Todos os direitos reservados.
            </div>
        </div>
    </footer>
    <div id="quizModal">
        <div class="quiz-container">
            <button id="closeQuiz" class="quiz-close">&times;</button>
            <div id="quizContent" class="quiz-content">
                
            </div>
        </div>
    </div>
@endsection
@section('javascript')
<script>
    class QuizModal {
        constructor() {
            this.modal = document.getElementById('quizModal');
            this.content = document.getElementById('quizContent');
            this.closeBtn = document.getElementById('closeQuiz');
            this.currentStep = null;
            this.sessionId = null;
            this.userData = {};
            
            this.init();
        }
        init() {
            const consultButton = document.getElementById('consultButton');
            consultButton.addEventListener('click', () => this.open());
            this.closeBtn.addEventListener('click', () => this.close());
            
            this.modal.addEventListener('click', (event) => {
                if (event.target === this.modal) {
                    this.close();
                }
            });
        }
        async open() {
            this.modal.style.display = 'flex';
            await this.startQuiz();
        }
        close() {
            this.modal.style.display = 'none';
            this.reset();
        }
        reset() {
            this.currentStep = null;
            this.sessionId = null;
            this.userData = {};
            this.content.innerHTML = '';
        }
        async startQuiz() {
            try {
                this.showLoading('Iniciando consulta...');

                const urlParams = new URLSearchParams(window.location.search);
                const params = {};
                urlParams.forEach((value, key) => {
                    params[key] = value;
                });

                const response = await fetch("{{ url('/api/start-quiz') }}", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ urlParams: params })
                });

                const data = await response.json();

                if (data.success) {
                    this.sessionId = data.sessionId;
                    this.userData.urlParams = params;
                    this.renderStep(data.step);
                } else {
                    this.showError(data.error || 'Erro ao inicializar consulta');
                }
            } catch (error) {
                console.error('Erro ao iniciar quiz:', error);
                this.showError('Erro de conexão. Tente novamente.');
            }
        }

        async nextStep(stepData = {}) {
            try {
                this.showLoading('Processando...');
                const response = await fetch("{{ url('/api/step-quiz') }}", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({
                        stepData: {
                            ...stepData,
                            currentStep: this.currentStep?.id,
                            sessionId: this.sessionId
                        }
                    })
                });

                const data = await response.json();

                if (data.success) {
                    if (data.userData) {
                        this.userData = { ...this.userData, ...data.userData };
                    }
                    this.renderStep(data.step);
                    if (data.step.autoRedirect) {
                        setTimeout(() => {
                            window.location.href = "{{ url('/identificacao') }}";
                        }, data.step.redirectDelay || 3000);
                    }
                } else {
                    this.showError(data.error || 'Erro ao processar');
                }
            } catch (error) {
                console.error('Erro ao processar etapa:', error);
                this.showError('Erro de conexão. Tente novamente.');
            }
        }
        renderStep(step) {
            this.currentStep = step;
            let html = '';
            if (step.type === 'captcha') {
                html = `
                    <div class="quiz-icon ${step.iconColor}">
                        ${this.getIcon(step.icon)}
                    </div>
                    <h2 class="quiz-title">${step.title}</h2>
                    ${step.question ? `<div class="quiz-question">${step.question}</div>` : ''}
                    <form onsubmit="quiz.handleCaptchaSubmit(event)">
                        <input 
                            type="${step.input.type}" 
                            id="quizInput"
                            placeholder="${step.input.placeholder}"
                            class="quiz-input"
                            ${step.input.required ? 'required' : ''}
                            autofocus
                        />
                        <button type="submit" class="quiz-button">
                            ${step.button?.text || 'VERIFICAR'}
                        </button>
                    </form>
                `;
            } else {
                html = `
                    <div class="quiz-icon ${step.iconColor}">
                        ${this.getIcon(step.icon)}
                    </div>
                    <h2 class="quiz-title">${step.title}</h2>
                    <p class="quiz-description">${step.description}</p>
                    ${step.loadingText ? `<p style="font-size: 14px; color: #718096; margin-bottom: 20px;">${step.loadingText}</p>` : ''}
                `;
            }
            if (step.type === 'welcome' && step.button) {
                html += `
                    <button onclick="quiz.nextStep()" class="quiz-button">
                        ${step.button.text}
                    </button>
                `;
            }
            if (step.type === 'loading') {
                this.closeBtn.style.display = 'none';
                
                html += `
                    <div class="progress-bar">
                        <div class="progress-fill" style="width: 100%"></div>
                    </div>
                `;
                if (step.progressSteps) {
                    html += '<div class="progress-steps">';
                    step.progressSteps.forEach(stepText => {
                        html += `<p>${stepText}</p>`;
                    });
                    html += '</div>';
                }
            } else {
                this.closeBtn.style.display = 'block';
            }
            
            this.content.innerHTML = html;
        }
        handleCaptchaSubmit(event) {
            event.preventDefault();
            const input = document.getElementById('quizInput');
            const value = input.value.trim();
            
            if (!value) return;
            
            this.nextStep({ captcha: parseInt(value) });
        }
        getIcon(iconName) {
            switch (iconName) {
                case 'check-circle':
                    return '<i class="fas fa-check-circle"></i>';
                case 'shield':
                    return '<i class="fas fa-shield-alt"></i>';
                case 'loader':
                    return '<i class="fas fa-spinner fa-spin"></i>';
                default:
                    return '<i class="fas fa-check-circle"></i>';
            }
        }
        showLoading(message) {
            this.content.innerHTML = `
                <div style="display: flex; align-items: center; justify-content: center; gap: 10px;">
                    <div class="spinner"></div>
                    <span>${message}</span>
                </div>
            `;
        }
        showError(message) {
            this.content.innerHTML = `
                <div class="quiz-icon red">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <h2 class="quiz-title" style="color: #742a2a;">Erro</h2>
                <div class="error-message">${message}</div>
                <button onclick="quiz.close()" class="quiz-button" style="background: #a0aec0;">
                    Fechar
                </button>
            `;
        }
    }
    const quiz = new QuizModal();
</script>
@endsection